--------------------------------------------------------------------------------
-- Easy HW "ahoj" test for LCD driver
--
-- Michal TRS
-- trsm1@fel.cvut.cz
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

Library UNISIM;
use UNISIM.vcomponents.all;

entity lcd_hw_test is
  Port ( 
   CLK         :  in std_logic;
   AS_RESET_BTN:  in std_logic;
   RDY         : out std_logic;
   -- low level
   DATA        : out std_logic_vector(7 downto 0);
   RS          : out std_logic;
   RW          : out std_logic;
   E           : out std_logic
  );
end lcd_hw_test;

architecture lcd_hw_test_body of lcd_hw_test is

   signal as_reset   : std_logic;

   signal ascii   : std_logic_vector(7 downto 0);
   signal vld     : std_logic;
   signal oper    : std_logic_vector(1 downto 0);
   signal llvl_rdy: std_logic;
   signal drv_rdy : std_logic;
   signal finish  : std_logic;

   type t_st is (st_wait, st_init, st_wA, st_wH, st_wO, st_wJ, st_end);
   signal curs, nexts : t_st;

  component lcd
   Port (
      CLK         : in std_logic;
      AS_RESET    : in std_logic; 
      -- ------------------------
      OPER        : in std_logic_vector(1 downto 0);
      -- 00 - clear display
      -- 01 - return cursor home
      -- 10 - set DDRAM address
      -- 11 - write ASCII
      ASCII       : in std_logic_vector(7 downto 0);
      VLD         : in std_logic;
      RDY         : out std_logic;
      -- low level
      DATA        : out std_logic_vector(7 downto 0);
      RS          : out std_logic;
      RW          : out std_logic;
      E           : out std_logic);
   end component;


   component wait_cnt
   Generic(
      cnt_msb  : natural := 15);
   Port ( 
      CLK      : in std_logic;
      AS_RESET : in std_logic;
      START    : in std_logic;
      FINISH   : out std_logic);
   end component;


begin
   
   
   BUFG_inst : BUFG
   port map (
      O => as_reset,     -- Clock buffer output
      I => AS_RESET_BTN      -- Clock buffer input
   );


   lcd_ctrl: lcd port map (
      CLK      => CLK,
      AS_RESET => as_reset,
      OPER     => oper,
      ASCII    => ascii,
      VLD      => vld,
      RDY      => llvl_rdy,
      DATA     => DATA,
      RS       => RS,
      RW       => RW,
      E        => E
   );


   RDY <= llvl_rdy;

   cnt : wait_cnt generic map(
      cnt_msb  => 15)            
    port map (
      CLK => CLK,
      AS_RESET => as_reset,
      START => llvl_rdy,
      FINISH => finish
   );

   drv_rdy <= finish and llvl_rdy;


   process(CLK, as_reset)
   begin
      if as_reset = '1' then
         curs <= st_wait;
      elsif CLK= '1' and CLK'event then
         curs <= nexts;
      end if;
   end process;


   next_log:process(curs, drv_rdy)
   begin
      nexts <= curs;
      case (curs) is  
         when st_wait =>      
            if drv_rdy = '1' then
               nexts <= st_init;
            end if;
         when st_init =>
            if drv_rdy = '1' then
               nexts <= st_wA;
            end if;
         when st_wA =>
            if drv_rdy = '1' then
               nexts <= st_wH;
            end if;            
         when st_wH =>
            if drv_rdy = '1' then
               nexts <= st_wO;
            end if;
         when st_wO =>
            if drv_rdy = '1' then
               nexts <= st_wJ;
            end if;
         when st_wJ =>
            if drv_rdy = '1' then
               nexts <= st_end;
            end if;
         when st_end =>
            null;
      end case;
   end process;


   out_log: process(curs, drv_rdy)
   begin
      oper <= "11";
      vld <= '0';
      ascii <= (others => '0');

      case (curs) is        
         when st_wait =>      
            if drv_rdy = '1' then
               -- return cursor home & set DDRAM addr to 0
               ascii <= (others => '0');
               oper  <= "10";
               vld   <= '1';
            end if;
         when st_init =>
            if drv_rdy = '1' then
               ascii <= X"41";
               vld <= '1';
            end if;
         when st_wA =>
            if drv_rdy = '1' then
               ascii <= X"68";
               vld <= '1';
            end if;            
         when st_wH =>
            if drv_rdy = '1' then
               ascii <= X"6F";
               vld <= '1';
            end if;
         when st_wO =>
            if drv_rdy = '1' then
               ascii <= X"6A";
               vld <= '1';
            end if;
         when others =>
            null;
      end case;
   end process;


end lcd_hw_test_body;
