--------------------------------------------------------------------------------
-- DIO2 board LCD driver
-- hardware test - testbench
--
-- Michal TRS
-- trsm1@fel.cvut.cz 
--------------------------------------------------------------------------------

LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;

ENTITY lcd_hw_test_tb_vhd IS
END lcd_hw_test_tb_vhd;

ARCHITECTURE behavior OF lcd_hw_test_tb_vhd IS 

	-- Component Declaration for the Unit Under Test (UUT)
	COMPONENT lcd_hw_test2
	PORT(
		CLK : IN std_logic;
		AS_RESET_BTN : IN std_logic;          
		RDY : OUT std_logic;
		DATA : OUT std_logic_vector(7 downto 0);
		RS : OUT std_logic;
		RW : OUT std_logic;
		E : OUT std_logic
		);
	END COMPONENT;

	--Inputs
	SIGNAL CLK :  std_logic := '0';
	SIGNAL AS_RESET_BTN :  std_logic := '0';

	--Outputs
	SIGNAL RDY :  std_logic;
	SIGNAL DATA :  std_logic_vector(7 downto 0);
	SIGNAL RS :  std_logic;
	SIGNAL RW :  std_logic;
	SIGNAL E :  std_logic;

BEGIN

	-- Instantiate the Unit Under Test (UUT)
	uut: lcd_hw_test2 PORT MAP(
		CLK => CLK,
		AS_RESET_BTN => AS_RESET_BTN,
		RDY => RDY,
		DATA => DATA,
		RS => RS,
		RW => RW,
		E => E
	);

   CLK <= not CLK after 20 ns;

	tb : PROCESS
	BEGIN

      AS_RESET_BTN <= '1';
      wait for 100 ns;
      AS_RESET_BTN <= '0';

      wait for 30 ms;

		wait; -- will wait forever
	END PROCESS;

END;
