--------------------------------------------------------------------------------
-- DIO2 board LCD driver
-- wait counter
--
-- Michal TRS
-- trsm1@fel.cvut.cz 
--------------------------------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;


entity wait_cnt is
   Generic(
      cnt_msb  : natural := 15);
   Port ( 
      CLK      : in std_logic;
      AS_RESET : in std_logic;
      START    : in std_logic;
      FINISH   : out std_logic);
end wait_cnt;

architecture wait_cnt_body of wait_cnt is
   
   signal ce   : std_logic;
   signal cnt  : std_logic_vector(cnt_msb downto 0);            

   signal start_reg  : std_logic;
   signal start_re   : std_logic;

begin

   process(CLK,AS_RESET)
   begin
      if AS_RESET = '1' then
         start_reg <= '0';
      elsif CLK = '1' and CLK'event then
         start_reg <= START;
      end if;
   end process;

   start_re <= START and not start_reg;
      
   process(CLK, AS_RESET)   
   begin
      if AS_RESET = '1' then
         ce <= '0';
      elsif CLK = '1' and CLK'event then
         if start_re = '1' then
            ce <= '1';
         elsif cnt = conv_std_logic_vector(0,cnt_msb) then
            ce <= '0';
         end if;
      end if;
   end process;


   process(CLK,AS_RESET)
   begin
      if AS_RESET = '1' then
         cnt <= (0 => '1', others => '0');
      elsif CLK = '1' and CLK'event then
         if ce = '1' then
            cnt <= cnt + '1';
         end if;
      end if;
   end process;

   FINISH <= '1' when cnt = conv_std_logic_vector(0,cnt_msb)
        else '0';

end wait_cnt_body;
