--------------------------------------------------------------------------------
-- Copyright (c) 1995-2003 Xilinx, Inc.
-- All Right Reserved.
--------------------------------------------------------------------------------
--   ____  ____ 
--  /   /\/   / 
-- /___/  \  /    Vendor: Xilinx 
-- \   \   \/     Version : 7.1i
--  \   \         Application : ISE Foundation
--  /   /         Filename : test.vhw
-- /___/   /\     Timestamp : Mon Apr 24 23:08:26 2006
-- \   \  /  \ 
--  \___\/\___\ 
--
--Command: 
--Design Name: test
--Device: Xilinx
--

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;
USE IEEE.STD_LOGIC_TEXTIO.ALL;
USE STD.TEXTIO.ALL;

ENTITY test IS
END test;

ARCHITECTURE testbench_arch OF test IS
    COMPONENT stopky
        PORT (
            CLK : In std_logic;
            AS_RESET : In std_logic;
            BTN : In std_logic;
            DSWITCH : In std_logic;
            ANODES : Out std_logic_vector (6 DownTo 0);
            CAT1 : Out std_logic;
            CAT2 : Out std_logic
        );
    END COMPONENT;

    SIGNAL CLK : std_logic := '0';
    SIGNAL AS_RESET : std_logic := '1';
    SIGNAL BTN : std_logic := '0';
    SIGNAL DSWITCH : std_logic := '0';
    SIGNAL ANODES : std_logic_vector (6 DownTo 0) := "0000000";
    SIGNAL CAT1 : std_logic := '0';
    SIGNAL CAT2 : std_logic := '0';

    SHARED VARIABLE TX_ERROR : INTEGER := 0;
    SHARED VARIABLE TX_OUT : LINE;

    constant PERIOD : time := 200 ns;
    constant DUTY_CYCLE : real := 0.5;
    constant OFFSET : time := 100 ns;

    BEGIN
        UUT : stopky
        PORT MAP (
            CLK => CLK,
            AS_RESET => AS_RESET,
            BTN => BTN,
            DSWITCH => DSWITCH,
            ANODES => ANODES,
            CAT1 => CAT1,
            CAT2 => CAT2
        );

        PROCESS    -- clock process for CLK
        BEGIN
            WAIT for OFFSET;
            CLOCK_LOOP : LOOP
                CLK <= '0';
                WAIT FOR (PERIOD - (PERIOD * DUTY_CYCLE));
                CLK <= '1';
                WAIT FOR (PERIOD * DUTY_CYCLE);
            END LOOP CLOCK_LOOP;
        END PROCESS;

        PROCESS
            PROCEDURE CHECK_ANODES(
                next_ANODES : std_logic_vector (6 DownTo 0);
                TX_TIME : INTEGER
            ) IS
                VARIABLE TX_STR : String(1 to 4096);
                VARIABLE TX_LOC : LINE;
                BEGIN
                IF (ANODES /= next_ANODES) THEN
                    STD.TEXTIO.write(TX_LOC, string'("Error at time="));
                    STD.TEXTIO.write(TX_LOC, TX_TIME);
                    STD.TEXTIO.write(TX_LOC, string'("ns ANODES="));
                    IEEE.STD_LOGIC_TEXTIO.write(TX_LOC, ANODES);
                    STD.TEXTIO.write(TX_LOC, string'(", Expected = "));
                    IEEE.STD_LOGIC_TEXTIO.write(TX_LOC, next_ANODES);
                    STD.TEXTIO.write(TX_LOC, string'(" "));
                    TX_STR(TX_LOC.all'range) := TX_LOC.all;
                    STD.TEXTIO.Deallocate(TX_LOC);
                    ASSERT (FALSE) REPORT TX_STR SEVERITY ERROR;
                    TX_ERROR := TX_ERROR + 1;
                END IF;
            END;
            PROCEDURE CHECK_CAT1(
                next_CAT1 : std_logic;
                TX_TIME : INTEGER
            ) IS
                VARIABLE TX_STR : String(1 to 4096);
                VARIABLE TX_LOC : LINE;
                BEGIN
                IF (CAT1 /= next_CAT1) THEN
                    STD.TEXTIO.write(TX_LOC, string'("Error at time="));
                    STD.TEXTIO.write(TX_LOC, TX_TIME);
                    STD.TEXTIO.write(TX_LOC, string'("ns CAT1="));
                    IEEE.STD_LOGIC_TEXTIO.write(TX_LOC, CAT1);
                    STD.TEXTIO.write(TX_LOC, string'(", Expected = "));
                    IEEE.STD_LOGIC_TEXTIO.write(TX_LOC, next_CAT1);
                    STD.TEXTIO.write(TX_LOC, string'(" "));
                    TX_STR(TX_LOC.all'range) := TX_LOC.all;
                    STD.TEXTIO.Deallocate(TX_LOC);
                    ASSERT (FALSE) REPORT TX_STR SEVERITY ERROR;
                    TX_ERROR := TX_ERROR + 1;
                END IF;
            END;
            PROCEDURE CHECK_CAT2(
                next_CAT2 : std_logic;
                TX_TIME : INTEGER
            ) IS
                VARIABLE TX_STR : String(1 to 4096);
                VARIABLE TX_LOC : LINE;
                BEGIN
                IF (CAT2 /= next_CAT2) THEN
                    STD.TEXTIO.write(TX_LOC, string'("Error at time="));
                    STD.TEXTIO.write(TX_LOC, TX_TIME);
                    STD.TEXTIO.write(TX_LOC, string'("ns CAT2="));
                    IEEE.STD_LOGIC_TEXTIO.write(TX_LOC, CAT2);
                    STD.TEXTIO.write(TX_LOC, string'(", Expected = "));
                    IEEE.STD_LOGIC_TEXTIO.write(TX_LOC, next_CAT2);
                    STD.TEXTIO.write(TX_LOC, string'(" "));
                    TX_STR(TX_LOC.all'range) := TX_LOC.all;
                    STD.TEXTIO.Deallocate(TX_LOC);
                    ASSERT (FALSE) REPORT TX_STR SEVERITY ERROR;
                    TX_ERROR := TX_ERROR + 1;
                END IF;
            END;
            BEGIN
                -- -------------  Current Time:  385ns
                WAIT FOR 385 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  1185ns
                WAIT FOR 800 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  1585ns
                WAIT FOR 400 ns;
                AS_RESET <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  2585ns
                WAIT FOR 1000 ns;
                BTN <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  2985ns
                WAIT FOR 400 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  4385ns
                WAIT FOR 1400 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  6695ns
                WAIT FOR 2310 ns;
                DSWITCH <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  6893ns
                WAIT FOR 197 ns;
                DSWITCH <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  9622ns
                WAIT FOR 2729 ns;
                DSWITCH <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  9848ns
                WAIT FOR 226 ns;
                DSWITCH <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  15385ns
                WAIT FOR 5536 ns;
                BTN <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  15585ns
                WAIT FOR 200 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  16033ns
                WAIT FOR 448 ns;
                DSWITCH <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  16160ns
                WAIT FOR 127 ns;
                DSWITCH <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  16685ns
                WAIT FOR 524 ns;
                DSWITCH <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  17185ns
                WAIT FOR 499 ns;
                BTN <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  17585ns
                WAIT FOR 400 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  18385ns
                WAIT FOR 800 ns;
                BTN <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  18985ns
                WAIT FOR 600 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  46585ns
                WAIT FOR 27600 ns;
                BTN <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  46785ns
                WAIT FOR 200 ns;
                BTN <= '0';
                -- -------------------------------------
                -- -------------  Current Time:  48303ns
                WAIT FOR 1518 ns;
                DSWITCH <= '1';
                -- -------------------------------------
                -- -------------  Current Time:  48642ns
                WAIT FOR 339 ns;
                DSWITCH <= '0';
                -- -------------------------------------
                
                WAIT FOR 30 us;
                
                wait;

            END PROCESS;

    END testbench_arch;

