/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/

/*
   Dieser Code ist Teil der BlueMP3-Firmware wie den den Ausgaben
   8, 9 und 10 2004 des Computermagazins c't.

   Der Autor bernimmt keinerlei Garantie fr diesen Code. Dieser
   Code darf ohne Zustimmung des Autors in keiner Form weitervertrieben 
   werden.

   Dieser Code ist fr rein diadaktische Zwecke gedacht und ist 
   mglicherweise nicht kompatibel mit den Bluetooth-Standards.
*/

/*
   This code is part of the BlueMP3 firmware as published in issues
   8, 9, and 10 2004 of the german computer magazine c't. 

   The code comes without warantee of any kind, either expressed or
   implied. This code may not be distributed in any form without
   permission by the author.

   The code is provided for educational purposes only and may not comply 
   to the bluetooth standards.
*/


#ifndef CPU_H
#define CPU_H

#include "types.h"

#define CLK_INTERNAL 0
#define CLK_CRYSTAL  1

#define CPU_CLOCK 7372800

#define CPU_MICROSEC(a) ((a)*CPU_CLOCK/7000000)
#define CPU_MILLISEC(a) ((a)*CPU_CLOCK/7000)
#define CPU_SEC(a)      ((a)*CPU_CLOCK/7)

#define nop() ({__asm__ __volatile__ ("nop\n\t":);})

/* nop/1, subi/1, sbc/1, sbc/1, sbc/1, brcc/2 -> 7 clocks */
static inline void cpu_delay(u32_t delay) {
  while ( delay-- != 0) nop();
}

#endif // CPU_H
