/*  
  debug.h
*/

#ifndef DEBUG_H
#define DEBUG_H

/*
 * Enable debuging output. DEBUG must be defined if DEBUG_UART
 * ist defined!
 */
//#define DEBUG
//#define DEBUG_UART


#ifdef DEBUG

#include "types.h"
void debug_message(char* err);
#ifdef DEBUG_UART
void put_hex(bool_t in, u08_t val);
#endif

#define DEBUG_HCI(a) debug_message("HCI: "); debug_message (a)
#define DEBUG_L2CAP(a) debug_message("L2CAP: "); debug_message (a)

#else

#define DEBUG_HCI(a)
#define DEBUG_L2CAP(a)

#endif

#endif //DEBUG_H
