/*
  hci_acl.h
*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/



#ifndef HCI_ACL_H
#define HCI_ACL_H

#include "hci_con.h"

#define HCI_ACL_CMD_MASK  0xf000
#define HCI_ACL_HND_MASK  0x0fff

/* hci packet types */
#define L2CAP_CONTINUE    0x1000
#define L2CAP_START       0x2000
#define ACTIVE_BROADCAST  0x4000
#define PICONET_BROADCAST 0x8000

extern u16_t acl_expect, acl2send;  /* acl state holding */

void hci_acl_decode(u16_t cmd);
void hci_acl_send(hci_acl_con_t *acl, u16_t len, bool_t l2start);
void hci_acl_set(u16_t num, u16_t size);
void hci_acl_pkt_completed(u16_t num);
u16_t hci_acl_fsize(void);

u08_t hci_acl_get(void);
u16_t hci_acl_get_u16(void);
void  hci_acl_drop(u08_t num);

#endif //HCI_ACL_H
