/* 
   hci_callback.h
*/

/*
  This file is copyright 2003 by Till Harbaum, BeeCon GmbH 
*/

#ifndef HCI_CALLBACK_H
#define HCI_CALLBACK_H

#include "hci_con.h"
#include "hci_event.h"
#include "l2cap.h"

typedef struct {
  u08_t type;

  /* union of all kinds of event data pointers */
  union {
    /* hci data structures */
    hci_acl_con_t *acl;

    /* generic error code */
    u08_t *error;

    /* l2cap data structures */
    hci_l2con_t *l2con;

    /* dummy pointer */
    void *data;
  };

} PACKED hci_event_t;

/* event types */
#define HCI_EVT_NONE                       0x00 
#define HCI_EVT_ACL_CONNECTED              0x04
#define HCI_EVT_ACL_DISCONNECTED           0x05
#define HCI_EVT_ACL_CONNECTION_FAILED      0x09

#define L2CAP_EVT_ACKNOWLEDGE_CONNECTION   0x80
#define L2CAP_EVT_NOTIFY_CONNECTION        0x81
#define L2CAP_EVT_NOTIFY_DISCONNECTION     0x82
#define L2CAP_EVT_NOTIFY_RECEIVE           0x83
#define L2CAP_EVT_CONNECTION_FAILED        0x84

#define APP_PSM 0x1023

/* the user provided callback function */
bool_t hci_event_callback(hci_event_t *event);

/* it's internal pendant (with stack internal hooks) */
bool_t hci_internal_callback(u08_t type, void *data);

#endif // HCI_CALLBACK_H
