/*
  hci_con.h

  the strcutures used to store information about the clients
  and their connection states
*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/



#ifndef HCI_CON_H
#define HCI_CON_H

// this device only requires one single l2cap connection at a time
#define MAX_L2CON 1

// and it supports only one acl client at a time
#define HCI_ACL_CLIENTS 1

/* structure for connection request event */
typedef struct {
  u08_t bd_addr[6];
  u08_t cod[3];
} PACKED hci_con_req_t;

/* structure for connection complete event */
typedef struct {
  u08_t errcode;
  u16_t handle;
  u08_t bd_addr[6];
  u08_t link_type;
  u08_t encryption;
} PACKED hci_con_comp_t;

/* structure for disconnection complete event */
typedef struct {
  u08_t errcode;
  u16_t handle;
  u08_t reason;
} PACKED hci_disc_comp_t;

/* forward definition for cyclic inclusion */
struct hci_acl_con;

/* information stored about l2cap connections */
typedef struct {
  u16_t psm;                 // psm of this connection
  u16_t scid;                // scid of opposite side
  u16_t lid;                 // save id of last command

  struct hci_acl_con *acl;   // pointer to parent acl
} PACKED hci_l2con_t;

/* information stored about acl connections */
typedef struct acl_con {
  u16_t handle;          /* handle of this connection */
  u08_t bdaddr[6];       /* bdaddr of other device */

  u16_t l2cap_expect;    /* state holding for l2cap data reception */
  u16_t l2cap2send;      /* state holding for data transmission */
  u08_t ident;           /* l2cap command identifier */

  /* each acl client supports a fixed number of l2cap connections */
  hci_l2con_t l2con[MAX_L2CON];
} PACKED hci_acl_con_t;

/* global info about the existing acl connection(s) */
extern hci_acl_con_t acl_con[HCI_ACL_CLIENTS];

#define HCI_ROLE_BECOME_MASTER 0
#define HCI_ROLE_REMAIN_SLAVE  1

#define HCI_NO_SLOT 0xff

/* disconnect reasons */
#define HCI_REASON_USER  0x13

void  hci_con_init(void);
void  hci_event_connection_request(void);
void  hci_event_connection_complete(void);
void  hci_event_disconnection_complete(void);
u08_t hci_con_new_l2cap_entry(hci_acl_con_t *acl);
hci_acl_con_t *hci_get_acl_slot(u16_t handle);
void hci_change_pkt_type(u16_t handle, u16_t type);

#endif
