/*
  hci_event.h

  hci layer event processing
*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/



#ifndef HCI_EVENT_H
#define HCI_EVENT_H

/* supported hci event types */
#define EVT_CONNECTION_COMPLETE            0x03
#define EVT_CONNECTION_REQUEST             0x04
#define EVT_DISCONNECT_COMPLETE            0x05
#define EVT_COMMAND_COMPLETE               0x0e
#define EVT_COMMAND_STATUS                 0x0f
#define EVT_HARDWARE_ERROR                 0x10
#define EVT_NUMBER_OF_COMPLETE_PKTS        0x13

#define EVT_PIN_CODE_REQUEST	   		   0x16
#define EVT_LINK_KEY_REQUEST	   		   0x17



extern u08_t hci_further_commands;
u08_t hci_event(u16_t cmd, void *data);

#endif // HCI_EVENT_H
