/*
  utils.h

*/
/* 
   BlueMP3 firmware (c) 2004 by Till Harbaum, harbaum@beecon.de
*/



#ifndef UTILS_H
#define UTILS_H

#include "types.h"
#include <stdarg.h>

/* variant with a bit length field. good for inlining */
static inline void utils_memcpy(void *dst, void *src, u08_t len) {
  u08_t *dst8 = (u08_t*)dst;
  u08_t *src8 = (u08_t*)src;

  while(len--)
    *dst8++ = *src8++;
}

static inline void utils_memzero(void *dst, u16_t len) {
  u08_t *dst8 = (u08_t*)dst;

  while(len--)
    *dst8++ = 0;
}

#endif // UTILS_H
