#!/bin/bash

awk -v vst_file=$1 -v mem_num=$2 -v typ=$3 '

  BEGIN   {
    FS=" "; clr_mem(); radku = 0; addr = 0; addr1 = 0;
  
    if (typ != 0) { # tento format INIT_00 => X"    
      printf("   RAMB4_S4_inst_%X : RAMB4_S4\n   generic map (\n",mem_num);
    }
  }   

  function  clr_mem(){
       mem[0] = "";
       mem[1] = "";
       mem[2] = "";
       mem[3] = "";
       mem[4] = "";
  }

  function  pis1(i){
    if (typ == 0) { # tento format: attribute INITP_07 of ram_1024_x_18 : label is "
      printf("attribute INIT_%02X of RAMB4_S4_inst_%X : label is \"%s\";\n",i,mem_num,mem[mem_num]);    
    } else { # tento format INIT_00 => X"
      if ( i != 15)   
        printf("      INIT_%02X => X\"%s\",\n",i,mem[mem_num]);
      else
        printf("      INIT_%02X => X\"%s\"\n",i,mem[mem_num]);
    }
  }
  
  function todec(str) {
      hstr="0123456789ABCDEF";
      res=0;
      n=split(str,digit,"");
      for(i=1;i<=n;i++) {
        num=index(hstr,digit[i])-1;
        res=res+(num*16^(n-i));
      }
      return res;
    }
  
  
    {
      if (($1 >= "000") && ($1 <= "3FF") && (NR > 8) && (substr($0,11,1) != " ") ) {        
        addr1 = todec($1);
        while (addr < addr1){
          mem[0] = "0" mem[0];
          mem[1] = "0" mem[1];
          mem[2] = "0" mem[2];
          mem[3] = "0" mem[3];
          mem[4] = "0" mem[4];        
          if (length(mem[0]) == 64){
            pis1(radku);
            clr_mem();
            radku++;
          }
          addr++;
          #sprintf(saddr,"%03X",addr);
        }
        
        mem[0] = substr($0,11,1) mem[0];
        mem[1] = substr($0,10,1) mem[1];
        mem[2] = substr($0,9,1) mem[2];
        mem[3] = substr($0,8,1) mem[3];
        mem[4] = substr($0,7,1) mem[4]; 
        addr++;       
      }
      
      if (length(mem[0]) == 64){
       pis1(radku);
       clr_mem();
       radku++;
      }
    }
  
  END {
      for (i = length(mem[0]); i < 64; i++)
        mem[mem_num] = "0" mem[mem_num];
      pis1(radku);
      radku++;  
      
      mem[mem_num] = "0000000000000000000000000000000000000000000000000000000000000000";  
      for (i = radku; i < 16; i++)
        pis1(i);
                     
      if (typ != 0) { # tento format INIT_00 => X"
        printf("      )\n");
        printf("   port map (\n");
        if (mem_num != 4)        
          printf("      DO    => instruction(%d downto %d),  -- 4-bit data output\n",(mem_num+1)*4-1,mem_num*4);
        else  
           printf("      DO    => lastmem,  -- 2-bit data output\n");          
        printf("      ADDR  => address,   -- 10-bit address input\n");
        printf("      CLK   => clk,       -- Clock input\n");
        printf("      DI    => \"0000\",    -- 4-bit data input\n");
        printf("      EN    => %c1%c,       -- RAM enable input\n",39,39);
        printf("      RST   => %c0%c,       -- Synchronous reset input\n",39,39);
        printf("      WE    => %c0%c        -- RAM write enable input\n",39,39);
        printf("   );\n");          
      } else {
        printf("\n");
      }      

  
  }



' $1;

	
