package net.michaltrs;

import java.awt.BorderLayout;
import java.awt.Dimension;

import javax.swing.*;
import java.awt.*;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.JTextField;
import javax.swing.JLabel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.*;
import java.rmi.*;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseAdapter;

public class RipFrame extends JFrame implements Runnable{
    JPanel contentPane;
    JList jList1 = new JList();
    JScrollPane scrollPane = new JScrollPane(jList1);
    JTextField jTextField1 = new JTextField();
    JTextField jTextField2 = new JTextField();
    JTextField jTextField3 = new JTextField();
    JButton BtnAdd = new JButton();
    JButton BtnStart = new JButton();
    JButton RegBtn = new JButton();
    JButton BtnCreat = new JButton();
    JLabel jLabel1 = new JLabel();
    JLabel jLabel2 = new JLabel();
    JLabel jLabel3 = new JLabel();
    JLabel itLabel = new JLabel();
    JTextArea jTextArea1 = new JTextArea();

    public RipFrame() {
        try {
            setDefaultCloseOperation(EXIT_ON_CLOSE);
            jbInit();
        } catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /**
     * Component initialization.
     *
     * @throws java.lang.Exception
     */
    private void jbInit() throws Exception {
        contentPane = (JPanel) getContentPane();
        contentPane.setLayout(null);
        setSize(new Dimension(400, 300));
        setTitle("RIP");
        jList1.setBounds(new Rectangle(11, 38, 144, 159));
        jTextField1.setNextFocusableComponent(jTextField2);
        jTextField1.setText("B");
        jTextField1.setBounds(new Rectangle(93, 206, 137, 26));
        jTextField2.setNextFocusableComponent(BtnAdd);
        jTextField2.setText("1");
        jTextField2.setBounds(new Rectangle(317, 205, 44, 29));
        BtnAdd.setBounds(new Rectangle(24, 241, 73, 25));
        BtnAdd.setNextFocusableComponent(jTextField1);
        BtnAdd.setText("Pridej");
        BtnAdd.addActionListener(new RipFrame_BtnAdd_actionAdapter(this));
        BtnStart.setBounds(new Rectangle(231, 241, 73, 25));
        BtnStart.setText("Start");
        BtnStart.addActionListener(new RipFrame_BtnStart_actionAdapter(this));
        jLabel1.setText("Adresa:");
        jLabel1.setBounds(new Rectangle(33, 212, 48, 15));
        jLabel2.setText("Vzdalenost:");
        jLabel2.setBounds(new Rectangle(243, 211, 73, 15));
        jTextArea1.setText("");
        jTextArea1.setBounds(new Rectangle(174, 39, 208, 157));
        jTextField3.setNextFocusableComponent(BtnCreat);
        jTextField3.setText("A");
        jTextField3.setBounds(new Rectangle(94, 13, 94, 21));
        jLabel3.setText("Adresa nodu");
        jLabel3.setBounds(new Rectangle(17, 16, 87, 15));
        BtnAdd.addActionListener(new RipFrame_BtnAdd_actionAdapter(this));
        RegBtn.setBounds(new Rectangle(102, 241, 124, 25));
        RegBtn.setText("Registrovat server");
        RegBtn.addActionListener(new RipFrame_RegBtn_actionAdapter(this));
        itLabel.setBounds(new Rectangle(338, 15, 34, 15));
        BtnCreat.setBounds(new Rectangle(198, 11, 73, 25));
        BtnCreat.setNextFocusableComponent(jTextField1);
        BtnCreat.setText("Vytvor");
        BtnCreat.addActionListener(new RipFrame_BtnCreat_actionAdapter(this));
        BtnRem.setBounds(new Rectangle(309, 241, 73, 25));
        BtnRem.setText("Odeber");
        BtnRem.addActionListener(new RipFrame_BtnRem_actionAdapter(this));
        contentPane.add(jLabel1);
        contentPane.add(BtnAdd);
        contentPane.add(jTextArea1);
        contentPane.add(itLabel);
        contentPane.add(jLabel3);
        contentPane.add(jTextField3);
        contentPane.add(BtnCreat);
        contentPane.add(jList1);
        contentPane.add(BtnStart);
        contentPane.add(BtnRem);
        contentPane.add(RegBtn);
        contentPane.add(jTextField1);
        contentPane.add(jTextField2);
        contentPane.add(jLabel2);
    }


    static String[] ReCast(Object[] obs) {
        String[] res = new String[obs.length];
        for (int i = 0; i < obs.length; i++) {
            res[i] = (String)obs[i];
        }
        return res;
    }

    RoutingTable rt;
    Map localTab = new HashMap();

    Thread t = null;
    boolean stopThread = false;
    boolean runThread =false;

    int it = 0;
    String localAddress = null;
    JButton BtnRem = new JButton();
    public void BtnCreat_actionPerformed(ActionEvent e) {
        try {
            rt = new RoutingTable();
        } catch (RemoteException ex) {
        }
        localAddress = jTextField3.getText();
        rt.setName(localAddress);
        rt.AddItem(localAddress, localAddress, 0); // localhost
        jTextField3.setEnabled(false);
    }


    public void BtnAdd_actionPerformed(ActionEvent e) {
        String adresa = jTextField1.getText();
        int vzd = Integer.parseInt(jTextField2.getText());

        localTab.put(adresa,new Integer(vzd));
        rt.AddItem(adresa, adresa, vzd);
        PrintLocalTab();
    }


    void PrintLocalTab(){
        Object [] n = localTab.keySet().toArray();
        String [] vect = new String[n.length];
        Arrays.sort(n);
        for (int i = 0; i < n.length; i++) {
            vect[i] = n[i] + "  " + ((Integer)localTab.get(n[i])).toString();

        }
        jList1.setListData(vect);
    }


    public void run() {
        while (!stopThread) {
            // nacti vzdalene tabulky
            ArrayList remoteTables = new ArrayList();
            String[] adr = ReCast(localTab.keySet().toArray());

            for (int i = 0; i < adr.length; i++) {
                try {
                    RoutingTableInterface rti = (RoutingTableInterface) Naming.lookup("//localhost:1919/" + adr[i]);
                    remoteTables.add(rti.getTable(adr[i]));
                } catch (Exception ex) {
                    localTab.remove(adr[i]);
                }
            }

            // vypocitej novou tabulku
            // RemoteTables: ArrayList -> array of Map
            Map[] art = new HashMap[remoteTables.size()];
            for (int i = 0; i < remoteTables.size(); i++) {
                art[i] = (Map) remoteTables.get(i);
            }

            rt.UpdateTable(art,localTab,localAddress);

            // vypis tabulky
            rt.printTable(jTextArea1);
            itLabel.setText(Integer.toString(it++));

            try {
                t.sleep(5000); // pockej 5s
            } catch (InterruptedException ex) {
            }
        }
   }


    public void BtnStart_actionPerformed(ActionEvent e) {
        if (rt.isEmpty()) return;
        if (!runThread) {
            t = new Thread(this);
            t.start();
            BtnStart.setText("Stop");
            runThread = true;
        } else {
            stopThread = true;
            t.interrupt();
            runThread = false;
            BtnStart.setText("Start");
        }
    }


    public void RegBtn_actionPerformed(ActionEvent e) {
            rt.startServer(localAddress);
    }


    public void BtnRem_actionPerformed(ActionEvent e) {
        if (jList1.getSelectedIndex() == -1)
            return;
        Object[] neib = localTab.keySet().toArray();
        Arrays.sort(neib);
        localTab.remove(neib[jList1.getSelectedIndex()]);
        PrintLocalTab();
    }

}


class RipFrame_BtnRem_actionAdapter implements ActionListener {
    private RipFrame adaptee;
    RipFrame_BtnRem_actionAdapter(RipFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnRem_actionPerformed(e);
    }
}



class RipFrame_BtnCreat_actionAdapter implements ActionListener {
    private RipFrame adaptee;
    RipFrame_BtnCreat_actionAdapter(RipFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnCreat_actionPerformed(e);
    }
}


class RipFrame_RegBtn_actionAdapter implements ActionListener {
    private RipFrame adaptee;
    RipFrame_RegBtn_actionAdapter(RipFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.RegBtn_actionPerformed(e);
    }
}



class RipFrame_BtnStart_actionAdapter implements ActionListener {
    private RipFrame adaptee;
    RipFrame_BtnStart_actionAdapter(RipFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {
        adaptee.BtnStart_actionPerformed(e);
    }
}


class RipFrame_BtnAdd_actionAdapter implements ActionListener {
    private RipFrame adaptee;
    RipFrame_BtnAdd_actionAdapter(RipFrame adaptee) {
        this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e) {

        adaptee.BtnAdd_actionPerformed(e);
    }
}
