/* 
 * DSY uloha1 - Michal Trs 
 * TCP client
 */

#include <errno.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h> 

#include <stdio.h>

#define PORT            5566
#define	BUFFSIZE        128

int main(int argc, char *argv[]) {
    
   char buf[BUFFSIZE];
   int s; // socket number
   struct sockaddr_in sin; 
   
   FILE *f; 
   int size,rd_cnt;
   char len;
   char bufi[255];
    
   if (argc<3) {
      printf("Spatny pocet argumentu!\nPouziti: %s ip_adresa soubor", argv[0]);
      return 1;
   }
    
   if ((f = fopen(argv[2],"rb")) == NULL) {
      perror("spatny nazev souboru - soubor nelze otevrit");
      exit(1);
   }
   
     
   if ((s = socket(AF_INET,SOCK_STREAM,IPPROTO_TCP)) == -1) {  
      perror("nelze vytvorit socket");
      exit(1);
   }

   bzero(&sin, sizeof(sin));
   sin.sin_family = AF_INET;
   sin.sin_port = htons(PORT);
   sin.sin_addr.s_addr = inet_addr(argv[1]);
   if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) == -1) {
      perror("nelze connect");
      close(s);
      exit(1);
   }
   
   
   len = (char) (strlen(argv[2]) + 1);
   
   // poslu delku nazvu souboru
   if (send(s,&len,sizeof(len),0) == -1) {
      perror("Client - chyba pri send delky jmena\n");
      exit(1);
   }
   
   // poslu nazev souboru
   if (send(s,argv[2],len,0) != len) {
      perror("Client - chyba pri send jmena souboru\n");
      exit(1);
   }
 
   // zjistim a poslu delku souboru
   fseek(f,0,SEEK_END);
   size = ftell(f);   
   fseek(f,0,SEEK_SET);
   
   sprintf(bufi, "%d",size);
   len = strlen(bufi) + 1;
      
   if (send(s,&len,sizeof(len),0) == -1) {
      perror("Client - chyba pri send delky souboru\n");
      exit(1);
   }
   
   if (send(s,bufi,len,0) == -1) {
      perror("Client - chyba pri send delky souboru\n");
      exit(1);
   }
   
   while (size != 0) {
      if ((rd_cnt = fread(buf,1,BUFFSIZE,f)) != BUFFSIZE)
        if (rd_cnt != size) {
          perror("Client - chyba fread");
          exit(1);
        }
      if (send(s,buf,rd_cnt,0) != rd_cnt) {
        perror("chyba pri zapisu dat");
        exit(1);
      }
      
      size -= rd_cnt;
   
   }   
     
   printf("Client - odeslano %s B",bufi);  
     
   close(s);
   close(f);

   return 0;
}
 
