/* 
 * DSY uloha1 - Michal Trs
 * TCP server
 */

#include <stdio.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#define PORT	    5566
#define	BUFFSIZE	128

int main(int argc, char *argv[])
{
   char   buf[BUFFSIZE];
   int    sock_listen, sock_connect;
   struct sockaddr_in my_addr, rem_addr;
   int    rem_addr_length;
   int    pid;

   FILE *f; 
   int size,rd_cnt;
   char bufi[255], len;
   char *filename;
   

   if ((sock_listen = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP)) == -1)
   {
      perror("Socket nelze otevrit");
      exit(1);
   }

   bzero(&my_addr, sizeof(my_addr));
   my_addr.sin_family = AF_INET;
   my_addr.sin_port = htons(PORT);

   if (bind(sock_listen, (struct sockaddr *)&my_addr, sizeof(my_addr)) == -1)
   {
      perror("Chyba v bind");
      close(sock_listen); exit(1);
   }

   if (listen(sock_listen, 5) == -1)
   {
      perror("Nelze provest listen");
      close(sock_listen); exit(1);
   }

   while (1)
   {
      rem_addr_length = sizeof(rem_addr);
      if ((sock_connect = accept(sock_listen, (struct sockaddr *)&rem_addr, &rem_addr_length)) == -1)
      {
         perror("Nelze accept");
         close(sock_listen); exit(1);
      }
      
      pid = fork();

      if (pid == 0) {    
         
         // syn
         close(sock_listen);
         
         // prijmuti souboru
        
         // delka jmena souboru
         if (recv(sock_connect,&len,sizeof(len),0) == -1) {
            perror("Server - Chyba v prijmu delky jmena");
            exit(1);
         }   
         
         // jmeno souboru
         if (recv(sock_connect,buf,len,0) == -1 ) {
            perror("Server - Chyba v prijmu delky jmena");
            exit(1);
         }
         
         // novy soubor pro zapis
         filename = (char*) malloc(len);
         strncpy(filename,buf,len);
         f = fopen(filename,"wb");
         
         printf("Server - prijimam soubor %s\n: ",filename);
         
         // prijmu velikost souboru
         if (recv(sock_connect,&len,sizeof(len),0) == -1) {
            perror("Server - Chyba v prijmu delky delky dat");
            exit(1);
         }         
         
         if (recv(sock_connect,bufi,len,0) == -1) {
            perror("Chyba v prijmu delky dat");
            exit(1);
         }
         
         size = atoi(bufi); 
         printf("Server - velikost souboru %d\n:",size);
         
         while (size != 0) { 
         // cti data;      
            if ((rd_cnt = recv(sock_connect,buf,BUFFSIZE,0)) != BUFFSIZE)
               if (rd_cnt != size) {
                  perror("Server - Chyba v prijmu dat");
                  exit(1);           
               }
            fwrite(buf,rd_cnt,1,f);
            size -= rd_cnt;
         }
         
         // uklizeni
         
         printf("Prijato %s B\n",bufi);
         
         close(sock_connect);
         close(f);
         exit(0);
      
      } else                                  
        close(sock_connect);
   } // while
} // main
