#!/bin/bash
# Michal Trs
#
# 36NAN - strom telecom data
# uprava data z ustredny
# Vstup: Data z ustredny
# Vystup: 5 sloupcu na stdout
#  1 - den v tydnu (E):       0 - 6
#  2 - hodina ve dni (E):     0 - 23
#  3 - prichozi ustredna (K): cislovano od 0
#  4 - odchozi ustredna (L):  cislovano od 0
#  5 - zpusob ukonceni (M):   3 (uspech) -> 1, ostatni (neuspech) -> 0
#
#      Zprava o precislovani ustreden: telecom_report.txt
#

rm -f telecom_report.txt;

# prevod data na den v tydnu a hodinu ve dni + normalizace 0-1
awk 'BEGIN   {FS=","; cnt = 0; hour = 60 * 60; day = hour * 24; week = day * 7} 
    {h = int(($5%day)/hour);     # prevod casu
     d =  int(($5%week)/day); 
                
     if ($11 in dir) ;           # precislovani ustredny 0-cnt
       else dir[$11] = cnt++;
     if ($12 in dir) ; 
       else dir[$12] = cnt++;
       
     if ($13 == 3)               # vystup 3 -> 1; ostatni -> 0
       out = 1;
     else  
       out = 0;
                
     print d, h, dir[$11], dir[$12], out;
    }
    END{ 
        for (i in dir )          # zprava o preoznaceni ustreden
          print dir[i], i >> "telecom_report.txt";
        
        }' $1;

