using System;
using System.Collections.Generic;
using System.Text;
using System.IO;

namespace Batoh_SimAnneal
{
    class Program
    {
        static int mult = 1;
        static int samult = 20;


        static StreamReader sr;
        static StreamWriter sw;


        static void Main(string[] args)
        {
            if (args.Length == 2)
            {
                mult = int.Parse(args[1]);
            }
            else
            {
                if (args.Length != 1)
                {
                    Console.WriteLine("Knapsack problem (advanced iterative algorithm: Simulated Annealing)");
                    Console.WriteLine("Usage: Batoh-SimAnneal.exe input_file.txt");
                    return;
                }
            }

            string line = "";
            GreedyProofMod b = null;
            SimAnneal sa = null;
            Dyn d = null;
            
            int time = 0;
            int startTime;
            int instanceNr = 0;
            double totalTime = 0;

            int dbc = 0; // best cost (from Dyn)
            int tsac = 0; // total simual anealing cost
            int gpmc = 0; // gready proof cost

            double relErrGPM = 0.0;
            double relErrSA = 0.0;


            sr = new StreamReader(args[0]);


            if (File.Exists(Path.GetFileNameWithoutExtension(args[0]) + ".out.txt"))
                sw = new StreamWriter(Path.GetFileNameWithoutExtension(args[0]) + ".out.txt", true);
            else
            {
                sw = new StreamWriter(Path.GetFileNameWithoutExtension(args[0]) + ".out.txt", true);
                sw.WriteLine("n\tGPM err\tSA err\tTime\tSA parameters");
            }

            
            while ((line = sr.ReadLine()) != null)
            {
                for (int i = mult; i > 0; i--)
                {
                    b = new GreedyProofMod(line);
                    gpmc = b.Compute();

                    d = new Dyn(line);
                     dbc = d.Compute();

                     startTime = Environment.TickCount;
                     tsac = 0;
                     for (int j = 0; j < samult; j++)
                     {
                         //sa = new SimAnneal(line,b.ReturnConf());
                         sa = new SimAnneal(line);
                         tsac += sa.Compute();
                     }
                    
                    time += Environment.TickCount - startTime;
                }
                
                relErrGPM += ((double)(dbc - gpmc) / (double)dbc);
                relErrSA += (((double)dbc - ((double)tsac / (double)samult)) / (double)dbc);
                instanceNr++;
                //totalTime += time;
            }

            relErrGPM = relErrGPM / (double)instanceNr;
            relErrSA = relErrSA / (double)instanceNr;
            totalTime = (double)time / ((double)(instanceNr * mult)) * samult;

            sw.WriteLine("{0}\t{1}\t{2}\t{3}\t{4}", 
                b.n, 
                relErrGPM.ToString("0.####"), 
                relErrSA.ToString("0.####"), 
                totalTime.ToString("0.####"), 
                sa
            );
            
            //sw.WriteLine("Average time: {0} s", (double)totalTime / ((double)(instanceNr * mult * samult)));

            sr.Close();
            sw.Close();
        }
    }
}
