/************************************************************************ 
 *  buffer.c
 *  buffer pro odesilani a prijimani zprav
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifdef WIN32
#include <stdlib.h>
#include <memory.h>
#endif

#include <stdio.h>
#include "buffer.h"


void bufferInit(Buffer* buffer, int kapacita) {
  if (buffer && kapacita > 0) {
	buffer->kapacita = kapacita;
	buffer->velikost = 0;
	buffer->pozice = 0;
	buffer->buffer = (char*)malloc(sizeof(char) * kapacita);
	memset((void*)buffer->buffer, 0, kapacita * sizeof(char));
  }
}


void bufferDeinit(Buffer* buffer) {
  if (buffer && buffer->kapacita > 0) {
    buffer->velikost = 0;
    buffer->kapacita = 0;
	buffer->pozice = 0;
    if (buffer->buffer) {
      free((void*)buffer->buffer);
      buffer->buffer = 0;
    }
  }
}
