/************************************************************************ 
 *  pozice.c
 *  pozice na sachovnici
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#include "pozice.h"

#include "mpi.h"



void pozicePack(Pozice* zdroj, Buffer* cil) {
  if (zdroj && cil) {
    MPI_Pack(&(zdroj->x), 1, MPI_INT, cil->buffer, cil->kapacita, &(cil->velikost), MPI_COMM_WORLD);
	MPI_Pack(&(zdroj->y), 1, MPI_INT, cil->buffer, cil->kapacita, &(cil->velikost), MPI_COMM_WORLD);
  }
}

void poziceUnpack(Pozice* cil, Buffer* zdroj) {
  if (zdroj && cil) {
	MPI_Unpack(zdroj->buffer, zdroj->kapacita, &(zdroj->pozice), &(cil->x), 1, MPI_INT, MPI_COMM_WORLD);
	MPI_Unpack(zdroj->buffer, zdroj->kapacita, &(zdroj->pozice), &(cil->y), 1, MPI_INT, MPI_COMM_WORLD);
  }
}
