/************************************************************************ 
 *  sachovnice.c
 *  funkce pro praci s hracim polem, implementace
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifdef WIN32
#include <stdlib.h>
#include <memory.h>
#endif

#include "mpi.h"


#include <stdio.h>
#include "sachovnice.h"


void sachovniceInit(Sachovnice* sachovnice, int strana) {
  if (sachovnice) {
    int i;
    sachovnice->strana = strana;
    sachovnice->pole = (int**)malloc(sizeof(int*) * strana);
    for(i = 0; i < strana; i++) {
      sachovnice->pole[i] = (int*)malloc(sizeof(int) * strana);
      memset((void*)sachovnice->pole[i], 0, sizeof(int) * strana);
    }                
  }     
}

void sachovniceDeinit(Sachovnice* sachovnice) {
  if (sachovnice && sachovnice->strana > 0) {
    int i;
    for(i = 0; i < sachovnice->strana; i++) {
      free((void*)sachovnice->pole[i]);
    }             
    free((void*)sachovnice->pole);
    sachovnice->pole = 0;
    sachovnice->strana = 0;              
  }     
}


void sachovniceKopiruj(Sachovnice* zdroj, Sachovnice* cil) {
  if (zdroj && cil) {
	  int i;
	  sachovniceDeinit(cil);
	  sachovniceInit(cil, zdroj->strana);
	  for(i = 0; i < zdroj->strana; i++) {
		memcpy((void*)cil->pole[i], (void*)zdroj->pole[i], sizeof(int) * zdroj->strana);
	  }
  }
}


void sachovnicePack(Sachovnice* zdroj, Buffer* cil) {
  if (zdroj && cil) {
    int x, y;
	for(x = 0; x < zdroj->strana; x++) {
	  for(y = 0; y < zdroj->strana; y++) {
		  MPI_Pack(&(zdroj->pole[x][y]), 1, MPI_INT, cil->buffer, cil->kapacita, &(cil->velikost), MPI_COMM_WORLD);
	  }
	}
  }
}

void sachovniceUnpack(Sachovnice* cil, Buffer* zdroj) {
  if (zdroj && cil) {
    int x, y;
	for(x = 0; x < cil->strana; x++) {
	  for(y = 0; y < cil->strana; y++) {
		  MPI_Unpack(zdroj->buffer, zdroj->kapacita, &(zdroj->pozice), &(cil->pole[x][y]), 1, MPI_INT, MPI_COMM_WORLD);
	  }
	}
  }
}



int sachovniceNacti(Sachovnice* sachovnice, char* soubor, int k, int q) {
  FILE *fr;
  int x, y, i;
  
  fr = fopen(soubor, "r");
  if (fr == 0) {
    printf("File \"%s\" not found.", soubor);
	return 1;
  }
  
  for (i = 0; i < q; i++) {
    if (fscanf(fr, "%d,%d\n", &x, &y) != 2) {
       printf("File corrupted.\n");               
    }
    x--; y--;
	if (!sachovniceNa(sachovnice, x, y) || sachovniceVRohu(sachovnice, x, y)) {
      printf("Data on row %d is invalid.\n", i + 1);
      return 1;
    }    
    sachovnice->pole[x][y] = 1; // bily kamen
  }
  
  fclose(fr);
  return 0;
}


int sachovniceNa(Sachovnice* sachovnice, int x, int y) {
  return sachovnice && x >= 0 && x < sachovnice->strana && y >= 0 && y < sachovnice->strana;
}


int sachovniceVRohu(Sachovnice* sachovnice, int x, int y) {
  if (!sachovnice) {
    return 0;
  }
  return (x == 0 && y == 0) || (x == 0 && y == sachovnice->strana - 1) || (y == sachovnice->strana - 1 && y == 0) ||
	  (x == sachovnice->strana - 1 && y == sachovnice->strana - 1);
}


int sachovniceJeVedleBilyKamen(Sachovnice* sachovnice, int x, int y) {
  if (sachovnice && sachovniceNa(sachovnice, x, y)) {
    int ix, iy;
    for(ix = x - 1; ix <= x + 1; ix++) {
      for(iy = y - 1; iy <= y + 1; iy++) {
        if (sachovniceNa(sachovnice, ix, iy) && sachovnice->pole[ix][iy] == 1) {
          return 1;
        }
      }
    }
  }
  return 0;
}

void sachovniceUmistiKamen(Sachovnice* sachovnice, Tah* tah) {
  int x, y, smerX, smerY, ix, iy, count, i;

  if (!sachovnice || !tah || !sachovniceNa(sachovnice, tah->pozice.x, tah->pozice.y)) return ;
  tah->zahrany = 1;
  x = tah->pozice.x;
  y = tah->pozice.y;
  sachovnice->pole[x][y] = 2;
  
  for(smerX = -1; smerX <= 1; smerX++) {
    for(smerY = -1; smerY <= 1; smerY++) {
      if (smerX == 0 && smerY == 0) continue;
      /* pro kazdy z osmi smeru... */
      ix = x + smerX;
	  iy = y + smerY;
      count = 0;
      /* pokracuju dokud nevyjedu ze sachovnice nebo nenarazim na konec bilych kamenu */
      while(sachovniceNa(sachovnice, ix, iy) && sachovnice->pole[ix][iy] == 1) {
        ix += smerX;
        iy += smerY;
        count++;
      }
      /* pokud byla rada bilych kamenu zakoncena cernym kamenem, musim je prebarvit */
      if (count > 0 && sachovniceNa(sachovnice, ix, iy) && sachovnice->pole[ix][iy] == 2) {
        ix = x + smerX;
        iy = y + smerY;
        for(i = 0; i < count; i++) {
          tahPridejObarveni(tah, ix, iy);
          sachovnice->pole[ix][iy] = 2;
          ix += smerX;
          iy += smerY;    
        }
      }
    }          
  }   
}

void sachovniceVratTah(Sachovnice* sachovnice, Tah* tah) {
  if (sachovnice && tah) {
    int i;
    sachovnice->pole[tah->pozice.x][tah->pozice.y] = 0;
    for(i = 0; i < tah->pocetObarveni; i++) {
      sachovnice->pole[tah->obarveni[i].x][tah->obarveni[i].y] = 1;
    }
  }
}

int sachovniceHodnota(Sachovnice* sachovnice, int x, int y) {
  int result = 0, smerX, smerY, ix, iy, count;

  if (!sachovnice || !sachovniceNa(sachovnice, x, y)) return result;
  
  for(smerX = -1; smerX <= 1; smerX++) {
    for(smerY = -1; smerY <= 1; smerY++) {
      if (smerX == 0 && smerY == 0) continue;
      /* pro kazdy z osmi smeru... */
      ix = x + smerX;
	  iy = y + smerY;
      count = 0;
      /* pokracuju dokud nevyjedu ze sachovnice nebo nenarazim na konec bilych kamenu */
      while(sachovniceNa(sachovnice, ix, iy) && sachovnice->pole[ix][iy] == 1) {
        ix += smerX;
        iy += smerY;
        count++;
      }
      /* pokud byla rada bilych kamenu zakoncena cernym kamenem, zapocitam bile kameny */
      if (count > 0 && sachovniceNa(sachovnice, ix, iy) && sachovnice->pole[ix][iy] == 2) {
        result += count;
      }
    }          
  }
  
  return result; 
}



void sachovniceOznacPolickoASousedy(Sachovnice* sachovnice, int x, int y) {
  int smerX, smerY;
  sachovnice->pole[x][y] = 3;
  for(smerX = -1; smerX <= 1; smerX++) {
    for(smerY = -1; smerY <= 1; smerY++) {
      if (sachovniceNa(sachovnice, x + smerX, y + smerY) && 
          sachovnice->pole[x + smerX][y + smerY] == 1) {
        sachovniceOznacPolickoASousedy(sachovnice, x + smerX, y + smerY);                       
      }
    }
  }
}

int sachovnicePocetKomponent(Sachovnice* sachovnice) {
  int result = 0, x, y;

  if (!sachovnice) return result;

  for(x = 0; x < sachovnice->strana; x++) {
    for(y = 0; y < sachovnice->strana; y++) {
      if (sachovnice->pole[x][y] == 1) {
        result++;
        sachovniceOznacPolickoASousedy(sachovnice, x, y);
      }
    }      
  }
  
  for(x = 0; x < sachovnice->strana; x++) {
    for(y = 0; y < sachovnice->strana; y++) {
      if (sachovnice->pole[x][y] == 3) {
        sachovnice->pole[x][y] = 1;
      }
    }      
  }
  return result;
}



int sachovnicePocetVolnychSousedu(Sachovnice* sachovnice) {
  int result = 0, x, y, smerX, smerY, ix, iy;

  if (!sachovnice) return result;

  for(x = 0; x < sachovnice->strana; x++) {
    for(y = 0; y < sachovnice->strana; y++) {
      if (sachovnice->pole[x][y] == 1) {
        for(smerX = -1; smerX <= 1; smerX++) {
          for(smerY = -1; smerY <= 1; smerY++) {
            ix = x + smerX;
			iy = y + smerY;
            if (sachovniceNa(sachovnice, ix, iy) && sachovnice->pole[ix][iy] == 0) {
              sachovnice->pole[ix][iy] = 3;
              result++;
            }
          }
        }
      }
    }      
  }
  
  for(x = 0; x < sachovnice->strana; x++) {
    for(y = 0; y < sachovnice->strana; y++) {
      if (sachovnice->pole[x][y] == 3) {
        sachovnice->pole[x][y] = 0;
      }
    }      
  }
  
  return result;
}


int sachovniceZadnyBily(Sachovnice* sachovnice) {
  if (sachovnice) {
    int x, y;
    for(x = 0; x < sachovnice->strana; x++) {
      for(y = 0; y < sachovnice->strana; y++) {
        if (sachovnice->pole[x][y] == 1) return 0;
      }
    }
  }
  return 1;
}


void sachovniceVypis(Sachovnice* sachovnice, Vysledek* vysledek) {
  int x, y, i;
  if (!sachovnice) {
    return;
  }
  if (vysledek) {
    for(i = 0; i < vysledek->pocetTahu; i++) {
	    if (sachovniceNa(sachovnice, vysledek->pozice[i].x, vysledek->pozice[i].y)) {
	  	  sachovnice->pole[vysledek->pozice[i].x][vysledek->pozice[i].y] = i + 2;
	    }
    }
  }
  for(y = 0; y < sachovnice->strana; y++) {
	for(x = 0; x < sachovnice->strana; x++) {
	  i = sachovnice->pole[x][y];
	  if (i == 0) {
        printf(" ");
	  } else if (i == 1) {
	    printf("B");
	  } else {
        printf("%d", i - 1);
		sachovnice->pole[x][y] = 0;
	  }
	  if (x == sachovnice->strana - 1) {
		printf("\n");
	  }
    }
  }
}
