/************************************************************************ 
 *  sachovnice.h
 *  definice hraciho pole + funkce pro alokaci, etc ...
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifndef __SACHOVNICE_H__875230723__
#define __SACHOVNICE_H__875230723__

#include "tah.h"
#include "vysledek.h"
#include "buffer.h"

   typedef struct {
      int strana;
      int **pole;       
   } Sachovnice;

   /* pripravi sachovnici pro pouziti (hlavne alokace hraciho pole */
   void sachovniceInit(Sachovnice* sachovnice, int strana);
   
   /* dealokuje vsechny zdroje (tzn. uvolneni hraciho pole */
   void sachovniceDeinit(Sachovnice* sachovnice);

   /* prekopiruje sachovnici */
   void sachovniceKopiruj(Sachovnice* zdroj, Sachovnice* cil);

   /* zapakuje sachovnici */
   void sachovnicePack(Sachovnice* zdroj, Buffer* cil);

   /* rozpakuje sachovnici */
   void sachovniceUnpack(Sachovnice* cil, Buffer* zdroj);
   
   /* naplni hraci pole ze souboru, k = delka strany, q = pocet kamenu */
   int sachovniceNacti(Sachovnice* sachovnice, char *soubor, int k, int q);
   
   /* vraci zda je dana souradnice na dane sachovnici */
   int sachovniceNa(Sachovnice* sachovnice, int x, int y);
   
   /* vraci zda je v okoli alespon jeden bily kamen */
   int sachovniceJeVedleBilyKamen(Sachovnice* sachovnice, int x, int y);
   
   /* umistni cerny kamen na pozici uvedenou v tahu, do tahu ulozi info o obarvenych kamenech */
   /* zaroven oznaci tah jako zahrany */
   void sachovniceUmistiKamen(Sachovnice* sachovnice, Tah* tah);

   /* vrati tah, tj. odstrani polozeny cerny kamen a prebazni dane cerne kameny zpet na bile */
   void sachovniceVratTah(Sachovnice* sachovnice, Tah* tah);
   
   /* vraci pocet potencialne prebarvenych kamenu pro danou pozici */
   int sachovniceHodnota(Sachovnice* sachovnice, int x, int y);

   /* vraci zda je souradnice v rohu sachovnice */
   int sachovniceVRohu(Sachovnice* sachovnice, int x, int y);
   
   /* vraci pocet komponent bilych kamenu */
   int sachovnicePocetKomponent(Sachovnice* sachovnice);
   
   /* vraci pocet volnych sousedu bilych kamenu */
   int sachovnicePocetVolnychSousedu(Sachovnice* sachovnice);
   
   /* vraci zda na sachovnici uz neni zadny bily kamen */
   int sachovniceZadnyBily(Sachovnice* sachovnice);
   
   /* vypise sachovnici */
   void sachovniceVypis(Sachovnice* sachovnice, Vysledek* vysledek);
   

#endif
