/************************************************************************ 
 *  vysledek.c
 *  vysledek pro sekvencni reseni ...
 *
 *  36PAR - Othello 
 *  Michal Augustyn (augusm1@fel.cvut.cz), Michal Trs (trsm1@fel.cvut.cz)
*************************************************************************/

#ifdef WIN32
#include <stdlib.h>
#include <memory.h>
#endif

#include <stdio.h>
#include "vysledek.h"

void vysledekInit(Vysledek* vysledek) {
  if (vysledek) {
    vysledek->pocetTahu = 0;
    vysledek->pozice = 0;
  }     
}

void vysledekDeinit(Vysledek* vysledek) {
  if (vysledek) {
    vysledek->pocetTahu = 0;
    if (vysledek->pozice) {
      free((void*)vysledek->pozice);
      vysledek->pozice = 0;
    }
  }     
}

void vysledekPridejPozici(Vysledek* vysledek, Pozice pozice) {
  if (vysledek) {
    if (vysledek->pozice) {
      vysledek->pozice = (Pozice*)realloc((void*)vysledek->pozice, sizeof(Pozice) * (vysledek->pocetTahu + 1));
    } else {
      vysledek->pozice = (Pozice*)malloc(sizeof(Pozice) * 1);
    }
    vysledek->pozice[vysledek->pocetTahu] = pozice;
    vysledek->pocetTahu = vysledek->pocetTahu + 1;
  } 
}

void vysledekReverze(Vysledek* vysledek) {
  if (vysledek) {
    int i, c;
    Pozice pom;
    c = vysledek->pocetTahu;
    for(i = 0; i < (c / 2); i++) {
      pom = vysledek->pozice[i];
      vysledek->pozice[i] = vysledek->pozice[c - 1 - i];
      vysledek->pozice[c - 1 - i] = pom;
    }
  }
}

void vysledekVypis(Vysledek* vysledek) {
  int i;
  printf("Vysledek je %d.\n", vysledek->pocetTahu);
  for(i = 0; i < vysledek->pocetTahu; i++) {
	printf(" x: %d \t y: %d\n", vysledek->pozice[i].x + 1, vysledek->pozice[i].y + 1);
  }
  printf("\n\n");
}
