/*
 * Decompiled with CFR 0.152.
 */
package net.michaltrs;

import java.awt.Color;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.michaltrs.IP;
import net.michaltrs.Line;
import net.michaltrs.Oval;
import net.michaltrs.PaintServerInterface;
import net.michaltrs.Rect;
import net.michaltrs.Shape;
import net.michaltrs.Text;

public class PaintServer
extends UnicastRemoteObject
implements PaintServerInterface {
    private List shapes = new ArrayList();
    private Date timeStamp = new Date();

    public static void main(String[] args) {
        String addr = new IP().getHN();
        int portNum = 1099;
        String bName = "paintServer";
        if (args.length > 0) {
            bName = args[0];
        }
        if (args.length > 1) {
            try {
                portNum = Integer.parseInt(args[1]);
            }
            catch (Exception ex) {
                System.out.println("Port name must be a number! Using default port...");
            }
        }
        System.out.println("//" + addr + ":" + portNum + "/" + bName);
        String classdir = System.getProperty("user.dir") + "\\classes\\";
        System.out.println("Classes dir: " + classdir);
        try {
            PaintServer ps = new PaintServer();
            System.setProperty("java.rmi.server.codebase", "file:" + classdir);
            Naming.rebind("rmi://" + addr + ":" + portNum + "/" + bName, ps);
            System.out.println("new server created!");
        }
        catch (Exception ex) {
            System.out.println("Can't connect to Naming service! Are you sure that RMIregistry is running?");
            System.exit(1);
        }
    }

    public void paintLine(int x1, int y1, int x2, int y2, Color c) throws RemoteException {
        this.shapes.add(new Line(x1, y1, x2, y2, c));
        this.timeStamp = new Date();
        System.out.println("paintLine " + this.timeStamp);
    }

    public void paintRect(int x1, int y1, int x2, int y2, Color c) throws RemoteException {
        this.shapes.add(new Rect(x1, y1, x2, y2, c));
        this.timeStamp = new Date();
        System.out.println("paintRect " + this.timeStamp);
    }

    public void paintOval(int x1, int y1, int x2, int y2, Color c) throws RemoteException {
        this.shapes.add(new Oval(x1, y1, x2, y2, c));
        this.timeStamp = new Date();
        System.out.println("paintOval " + this.timeStamp);
    }

    public void paintText(int x, int y, String text, Color c) throws RemoteException {
        this.shapes.add(new Text(x, y, text, c));
        this.timeStamp = new Date();
        System.out.println("paint Text " + this.timeStamp + ": " + text);
    }

    public Shape[] getBoard() throws RemoteException {
        Object[] objs = this.shapes.toArray();
        Shape[] shas = new Shape[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            shas[i] = (Shape)objs[i];
        }
        System.out.println("getBoard " + shas.length);
        return shas;
    }

    public boolean isUpDate(Date d) throws RemoteException {
        return this.timeStamp.getTime() > d.getTime();
    }

    public void clearBoard() throws RemoteException {
        this.shapes.clear();
    }
}

