package net.michaltrs;

import javax.swing.*;
import java.awt.Graphics;
import java.awt.Graphics2D;

/**
 *
 * Componenta do ktere je vykreslovana grafika
 *
 * @author Michal Trs

 */
public class PaintingComp extends JComponent {
    private Shape[] shapes = null;

    public PaintingComp() {
    }

    /**
     * Vykresli pole objektu dedenych ze Shape
     *
     * @param g Graphics
     */
    public void paint(Graphics g) {
        Graphics gr = g.create();
        Graphics2D gr2D = (Graphics2D) gr;
        // kreslit do gr nebo gr2D
        if (shapes != null) {
            for (int i = 0; i < shapes.length; i++) {
                shapes[i].paint(gr2D);
            }
        }
        gr.dispose();
    }

    /**
     * Nastavi data a prekresli se
     * @param s Shape[]
     */
    public void setData(Shape[] s) {
        shapes = s;
        this.repaint();
    }


}
