LIBRARY ieee;
USE ieee.std_logic_1164.ALL;
USE ieee.std_logic_unsigned.all;
USE ieee.numeric_std.ALL;

ENTITY tb IS
END tb;

ARCHITECTURE behavior OF tb IS 

	-- Component Declaration for the Unit Under Test (UUT)
	COMPONENT vga_control
	PORT(
		CLK : IN std_logic;
		AS_RESET : IN std_logic;
		P1_UP : IN std_logic;
		P1_DOWN : IN std_logic;
		P2_UP : IN std_logic;
		P2_DOWN : IN std_logic;          
		ball_x : OUT natural;
		ball_y : OUT natural;
		batt1 : OUT natural;
		batt2 : OUT natural	
		);
	END COMPONENT;

	--Inputs
	SIGNAL CLK :  std_logic := '0';
	SIGNAL AS_RESET :  std_logic := '0';
	SIGNAL P1_UP :  std_logic := '0';
	SIGNAL P1_DOWN :  std_logic := '0';
	SIGNAL P2_UP :  std_logic := '0';
	SIGNAL P2_DOWN :  std_logic := '0';

	--Outputs
	SIGNAL ball_x : natural;
	SIGNAL ball_y : natural;
	SIGNAL batt1 :  natural;
	SIGNAL batt2 :  natural;

BEGIN

	
	uut: vga_control PORT MAP(
		CLK => CLK,
		AS_RESET => AS_RESET,
		P1_UP => P1_UP,
		P1_DOWN => P1_DOWN,
		P2_UP => P2_UP,
		P2_DOWN => P2_DOWN,
		ball_x => ball_x,
		ball_y => ball_y,
		batt1 => batt1,
		batt2 => batt2
	);

   CLK <= not CLK after 10 ns;	
       
   test : PROCESS
	BEGIN
		AS_RESET <= '1';
		
		wait for 100 ns;
		AS_RESET <= '0';
		P1_UP <= '1';
		P2_UP <= '1';
		wait for	15 ns	;
		P1_UP <= '0';
		
		wait for 25 us	;
		P1_DOWN <= '1';
      
		wait for	15 ns	;
		P1_DOWN <= '0';		
      wait for 10 us;
		
		P1_UP <= '1';
		wait; 
	END PROCESS;

END;
