--------------------------------------------------------------------------------
-- Company: 
-- Engineer:
--
-- Create Date:    17:11:00 04/18/06
-- Design Name:    
-- Module Name:    vga_drv - Behavioral
-- Project Name:   
-- Target Device:  
-- Tool versions:  
-- Description:
--
-- Dependencies:
-- 
-- Revision:
-- Revision 0.01 - File Created
-- Additional Comments:
-- 
--------------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

---- Uncomment the following library declaration if instantiating
---- any Xilinx primitives in this code.
--library UNISIM;
--use UNISIM.VComponents.all;

entity vga_drv is
   Generic (
      --  size in px
      batt_h   : natural := 120;
      batt_w   : natural := 30;
      ball_r   : natural := 10
   );
   Port ( 
      CLK      : in std_logic;
      AS_RESET : in std_logic;
      RED      : out std_logic;
      GRN      : out std_logic;
      BLU      : out std_logic;
      HS       : out std_logic;
      VS       : out std_logic;
      ball_x   : in natural;  -- 0 -:- 79
      ball_y   : in natural;  -- 0 -:- 59
      batt1    : in natural;  -- 0 -:- 59
      batt2    : in natural   -- 0 -:- 59
   );
end vga_drv;

architecture vga_drv_body of vga_drv is

   constant vTS    : natural := 521;
   constant vTdisp : natural := 480;
   constant vTpw   : natural := 2;
   constant vTfp   : natural := 10;
   constant vTbp   : natural := 29;

   constant hTS    : natural := 800;
   constant hTdisp : natural := 640;
   constant hTpw   : natural := 96;
   constant hTfp   : natural := 16;
   constant hTbp   : natural := 48;
                   
	signal cnt_horz   : std_logic_vector(9 downto 0);	 -- sirka 800
	signal cnt_vert   : std_logic_vector(9 downto 0);	 -- vyska 521
	signal disp_en    : std_logic;

   signal batt1_draw : boolean;
   signal batt2_draw : boolean;
   signal ball_draw  : boolean;


begin

	vgacnt:process(CLK, AS_RESET)
	begin
		if AS_RESET = '1' then
			cnt_horz <= (others => '0');
			cnt_vert <= (others => '0');
		elsif CLK = '1' and CLK'event then
			-- hcnt
			cnt_horz <= cnt_horz + 1;
			if cnt_horz = conv_std_logic_vector(hTS,10) then
				cnt_horz <= (others => '0');
				-- vcnt
				cnt_vert <= cnt_vert + 1;
				if cnt_vert = conv_std_logic_vector(vTS,10) then
					cnt_vert <= (others => '0');
				end if;
			end if;	
		end if;
	end process;


	-- genrate HS and VS
	HS <= '0' when cnt_horz < conv_std_logic_vector(hTpw,10)
	 else '1';

	VS <= '0' when cnt_vert < conv_std_logic_vector(vTpw,10)
	 else '1';

   -- display area
	disp_en <= '1' when ( cnt_horz >= conv_std_logic_vector(hTpw + hTbp, 10)
							and cnt_horz <  conv_std_logic_vector(hTpw + hTbp + hTdisp, 10)
							and cnt_vert >= conv_std_logic_vector(vTpw + vTbp, 10)
							and cnt_vert <  conv_std_logic_vector(vTpw + vTbp + vTdisp, 10) )
			else '0';

   -- enable for drawing items
   batt1_draw <= (cnt_vert - (vTpw + vTbp) >= batt1 * 8) and (cnt_vert - (vTpw + vTbp) <= batt1 * 8 + batt_h) and (cnt_horz - (hTpw + hTbp) >= 0) and (cnt_horz - (hTpw + hTbp) <= batt_w);

   batt2_draw <= (cnt_vert - (vTpw + vTbp) >= batt2 * 8) and (cnt_vert - (vTpw + vTbp) <= batt2 * 8 + batt_h) and (cnt_horz - (hTpw + hTbp) <= hTdisp) and (cnt_horz - (hTpw + hTbp) >= hTdisp - batt_w);

   ball_draw  <= (cnt_vert - (vTpw + vTbp) >= ball_y * 8 - ball_r) and (cnt_vert - (vTpw + vTbp) <= ball_y * 8 + ball_r) and (cnt_horz - (hTpw + hTbp) >= ball_x * 8 - ball_r) and (cnt_horz - (hTpw + hTbp) <= ball_x * 8 + ball_r);

	-- draw all
	process(disp_en, batt1_draw, batt2_draw, ball_draw)	
	begin
		if disp_en = '1' then  
         -- kresleni palek
         if batt1_draw or batt2_draw then
            -- green batts
            RED <= '0';
            GRN <= '1';
            BLU <= '0';			
         elsif ball_draw then
            -- yellow ball
            RED <= '1';
            GRN <= '1';
            BLU <= '1';   
         else
           -- white bg
           RED <= '0';
           GRN <= '0';
           BLU <= '0';
         end if;
      else
       	RED <= '0';
      	GRN <= '0';
      	BLU <= '0';	
      end if;
	end process;



end vga_drv_body;
