library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.STD_LOGIC_ARITH.ALL;
use IEEE.STD_LOGIC_UNSIGNED.ALL;

entity vga_top_level is
    Port ( CLK50     : in  std_logic;
           AS_RESET  : in  std_logic;
           P1_UP     : in  std_logic;
           P1_DOWN   : in  std_logic;
           P2_UP     : in  std_logic;
           P2_DOWN   : in  std_logic;
           RED       : out std_logic;
           GRN       : out std_logic;
           BLU       : out std_logic;
           HS        : out std_logic;
           VS        : out std_logic);
end vga_top_level;

architecture Behavioral of vga_top_level is

   constant cbatt_h : natural := 15; 
   constant cbatt_w : natural := 5;
   constant cball_r : natural := 1;

   signal iball_x : natural;
   signal iball_y : natural;
   signal ibatt1  : natural;
   signal ibatt2  : natural;

   signal clk25   : std_logic;
   signal CLK     : std_logic;

   component vga_drv	is
     Generic(
      --  size in px
      batt_h   : natural := 120;
      batt_w   : natural := 30;
      ball_r   : natural := 10);
     Port( 
      CLK      : in std_logic;
      AS_RESET : in std_logic;
      RED      : out std_logic;
      GRN      : out std_logic;
      BLU      : out std_logic;
      HS       : out std_logic;
      VS       : out std_logic;
      ball_x   : in natural;  -- 0 -:- 79
      ball_y   : in natural;  -- 0 -:- 59
      batt1    : in natural;  -- 0 -:- 59
      batt2    : in natural); -- 0 -:- 59
   end component vga_drv;

   component vga_control is
    Generic(
      --  size in px * 8
      batt_h         : natural := 15;
      batt_w         : natural := 5;
      ball_r         : natural := 1;
      screen_height  : natural := 60;
      screen_width   : natural := 80);
     Port( 
      CLK      : in std_logic;
      AS_RESET : in std_logic;
      P1_UP    : in std_logic;
      P1_DOWN  : in std_logic;
      P2_UP    : in std_logic;
      P2_DOWN  : in std_logic;
      ball_x   : out natural;
      ball_y   : out natural;
      batt1    : out natural;
      batt2    : out natural);
   end component vga_control;

begin

   -- ---------------------------------------
   -- CLK 50 -> 25 MHz
   -- ---------------------------------------
   process(CLK50,AS_RESET)
   begin
      if AS_RESET = '1' then
         CLK <= '0';
      elsif CLK50 = '1' and CLK50'event then
         CLK <= not CLK;
      end if;
   end process;
   -- ---------------------------------------

	drv: vga_drv 
	generic map (
	   batt_h	=> cbatt_h * 8,
      batt_w   => cbatt_w * 8,
      ball_r   => cball_r * 8)
	port map (
		CLK      => CLK,
      AS_RESET => AS_RESET,
      RED      => RED,
      GRN      => GRN,
      BLU      => BLU,
      HS       => HS,
      VS       => VS,
      ball_x   => iball_x,
      ball_y   => iball_y,
      batt1    => ibatt1,
      batt2    => ibatt2
	);

	ctrl: vga_control 
	generic map (
	   batt_h	      => cbatt_h,
      batt_w         => cbatt_w,
      ball_r         => cball_r,
      screen_height  => 60,
      screen_width   => 80
      )
	port map (
		CLK      => CLK,
      AS_RESET => AS_RESET,
      P1_UP 	=> P1_UP,
		P1_DOWN 	=> P1_DOWN,
		P2_UP    => P2_UP,
		P2_DOWN  => P2_DOWN,
      ball_x   => iball_x,
      ball_y   => iball_y,
      batt1    => ibatt1,
      batt2    => ibatt2
	);




end Behavioral;
