; Michal Trs
; vstup: prevadene cislo ve w0, pro 32b w1:w0
; vystup: promena - string zakonceny 0x0
; meni registry w0 - w3

.include "p30f4011.inc"
.global __reset

.text	                     ; segment pameti programu

__reset:
      ; nastaveni zasobniku
      mov #0xF00,w15
      mov #0xFFF,w0
      mov w0,SPLIM

      ; testovaci data
      mov #-32768,w0
      call disp_num
      mov #0x389a,w0
      call disp_hex
      mov #0x1234,w1
      mov #0x5678,w0
      call disp_hex32

      bra __reset

; cislo k prevodu v w0 pripadne w1:w0
disp_num:                  ; dec cislo v rozsahu -32768, 32767
      push w0
      push w1
      push w2
      push w5
      push w10
      push w12
      mov #10,w10          ; timhle delim
      mov #decn,w5         ; w5 - adresa kam ukladam
      clr w2               ; citac
      mov w0,w12           ; w12 - cislo ktere prevadim

      btst.z w0,#15        ; test jesli je cislo zaporne
      bra z,dec_loop       ; zaporne?
      neg w0,w12           ; => prevedu na kladne
      mov #0x2d,w1         ; '-'
      mov.b w1,[w5]
      inc w5,w5

   dec_loop:
      repeat #17
      div.u w12,w10        ; vysl ve w0, zbytek w1
      add #0x30,w1         ; -> ascii
      inc w2,w2
      push w1              ; zbytek = cislo ulozim na zasobnik
      mov w0,w12           ; mezivysledek => cislo k vydeleni
      cp0 w12
      bra z,dec_end        ; cislo je 0 -> konec deleni
      bra dec_loop

   dec_end: 			; prevraceni cisla ze zasobniku do promeny
      pop w1
      mov.b w1,[w5++]
      dec w2,w2
      bra nz,dec_end

      mov #0x0,w1
      mov.b w1,[w5]        ; ukoncim retezec nulou

      pop w12
      pop w10
      pop w5
      pop w2
      pop w1
      pop w0
      return


disp_hex:                  ; 16bit hex cislo
      push w2
      push w1
      mov #hex16,w2        ; adresa retezce
      mov #0,w1
      mov.b w1,[w2+4]      ; ukonceni retezce 0
      call hextoascii
      pop w1
      pop w2
      return


disp_hex32:                ; 32bit hex cislo
      push w0
      push w2
      push w3
      mov #hex32,w2        ; adresa retezce
      mov #0,w3
      mov.b w3,[w2+8]      ; ukonceni retezce 0
      add #4,w2
      call hextoascii
      sub w2,#4
      mov w1,w0
      call hextoascii
      pop w3
      pop w2
      pop w0
      return


hextoascii:                ; w0 - 16b hex cislo, w2 - promenna v pameti
      push w0
      push w1
      push w3
      push w4

      mov #0x3a,w4         ; pro porovnani zda cislo nebo a-f
      mov #4,w3            ; counter 4 x 4b

   htoa_loop: and w0,#0xF,w1
      add #0x30,w1         ; posun do ASCII - prictu '0'
      cpslt.b w1,w4        ; pokud je cislo preskoc
      add #7,w1            ; v ASCII mezi 9 a A rozdil 7 => musim jeste 1 pricist

      dec w3,w3            ; posun kvuli adresovani
      mov.b w1,[w2+w3]     ; ulozeni znaku do pameti
      inc w3,w3
      lsr w0,#4,w0         ; posun na dalsi znak ve w0
      dec w3,w3            ; posun na dalsi znak + snizim counter
      bra nz,htoa_loop

      pop w4
      pop w3
      pop w1
      pop w0
      return


.data ; promenne s vysledkem: max delka + 0x0
      decn:    .space 7
      hex16:   .space 5
      hex32:   .space 9
