; main soubor
; CT3 preruseni po 100ms
; CT2 preruseni od externihi vstupu - inkrementuje R7
; hlavni program R7 porovna s R6, if ruzne -> vypis a r6<-r7
; 

	.include "p30f4011.inc"
	
	config __FOSC, CSW_FSCM_OFF & XT_PLL4
	config __FWDT, WDT_OFF

	.global __reset
	.global __T3Interrupt

	.text	;segment pameti programu
__reset:
;nastaveni zasobniku
	mov #__SP_init, w15
	mov #__SPLIM_init, w0
	mov w0, SPLIM
	
	call disp_init		;inicializace
	call disp_clear		;smazani
	call disp_home		;nast. a 1. radek 1. znak

	; vypis f=
	mov #freq,w3		
	mov.b #'f', w0		; f
	mov.b w0,[w3++]
	mov.b #'=', w0		; =
	mov.b w0,[w3++]
	clr w0				; 0x0
	mov.b w0,[w3++]	
	mov #freq,w3
	call disp_str

	; inicializace unit
	mov #unit,w3		
	mov.b #'H', w0		; H
	mov.b w0,[w3++]
	mov.b #'z', w0		; z
	mov.b w0,[w3++]
	mov.b #' ', w0		; mezery do konce
	repeat #unit_size-4
	mov.b w0,[w3++]
	clr w0				; 0x0
	mov.b w0,[w3++]	
	

	bclr IFS0, #T3IF	; nulovn pznaku peruen
	bclr IFS0, #T2IF	; nulovn pznaku peruen

	bset IPC1, #T3IP0	; nastaven priority peruen na 7 (nejvy)
	bset IPC1, #T3IP1
	bset IPC1, #T3IP2
	
	bset IEC0, #T3IE	; povolen peruen
	bset IEC0, #T2IE	; povolen peruen

	mov	#0x02,w0
	mov w0, T2CON				
	mov #0x20,w0
	mov w0, T3CON	; preddelicka 64
	mov #11519,w0			; w0 = 0xffff
	mov w0, PR3		;prednastveni
	setm w0			; w0 = 0xffff
	mov w0, PR2		;prednastveni

;hlavn program
	clr w7
	;mov #500,w0
	clr w0				; nacteni poctu vnejsich pulzu
	mov w0, act_freq	; hodnota T2 po preruseni od T3

	mov #unit,w3

; pro ladeni - LED
	bclr TRISB, #0
	bclr TRISB, #1
	bset LATB, #0
	bclr LATB, #1

; start citacu
	bset T2CON, #TON	; 15. bit = start citace
	bset T3CON, #TON

loop1_main:
	mov act_freq, w6	; jsou ruzne -> vypis
	cp  w6, w7
	bra Z, loop1_main	; jsou stejne
	
;	call disp_clear
	mov #0x2,w0
	call disp_pos		; nastav pozici za "f="
	mov w6,w7			; ulozim novou hodnotu pro porovnani v dalsim pruchodu
	mul.uu  w6, #10, w8	; citam 100ms => x10
	mov  w8, w0			; vypis frekvence
	call disp_num
	call disp_str		; vypis jednotek, adresa ve w3

	bra loop1_main



__T3Interrupt:		; nulovn pznaku peruen
	bclr IFS0, #T3IF	;sluha peruen 
	push w0
	push SR
	mov TMR2, w0		;nacteni poctu vnejsich pulzu
	mov w0, act_freq
	clr TMR2
	btg LATB, #0
	btg LATB, #1

	pop SR
	pop w0
	retfie

	.equ unit_size,8 

.data
	freq:		.space 4	; f= 
	act_freq: 	.space 2	; frekvence od timeru 3
	unit:		.space #unit_size
	

