.include "p30f4011.inc"

   config __FOSC, CSW_FSCM_OFF & XT_PLL4
   config __FWDT, WDT_OFF

.global __reset
.global __IC1Interrupt

.text
__reset:
      ; nastaveni zasobniku
      mov #__SP_init,w15
      mov #__SPLIM_init,w0
      mov w0,SPLIM

      ; pro ladeni
      bclr TRISB, #0
      bclr TRISB, #1
      bset LATB, #0
      bclr LATB, #1

      ; Cekej na inicializaci LCD
      call disp_init          ; inicializace
      call disp_clear         ; smazani
      call disp_home          ; nast. a 1. radek 1. znak
      mov #'T', w0
      call disp_char
      mov #'=', w0
      call disp_char
      mov #7, w0
      call disp_pos           ; presun za cislo
      mov #'u', w0
      call disp_char
      mov #'s', w0
      call disp_char

      ; nastaven priority peruen na 7 (nejvy)
      bset IPC0, #IC1IP0;
      bset IPC0, #IC1IP1;
      bset IPC0, #IC1IP2;
      ; nulovn pznaku peruen
      ;the IC1IF interrupt flag
      bclr IFS0, #IC1IF       ; smazani flagu
      bset IEC0, #IC1IE       ; povoleni preruseni

      mov #0x0003 ,w0         ; internal clk T3 enable
      mov w0, IC1CON          ; nasteveni na 3 = kazda vzest. hrana

      clr TMR3
      mov #0x8000 ,w0         ; internal clk T3 enable
      mov w0, T3CON

      mov #0, w0
      mov w0, posledni
      mov w0, minula
      mov #1, w0              ; aby se poprve vypsal T=
      mov w0, update
      clr w2                  ; pro porovnavani, zda se lisi vypisovana hodnota od min vypisu
   mereni_T:
      mov update, w1
      cp0 w1
      bra Z, mereni_T
      mov #0, w0
      mov w0, update

      mov posledni, w0        ; porovnani posledni a minule hodnoty
      mov minula, w1
      sub w0, w1, w0
      btsc w0, #15            ; if 15. bit = 0 preskoci 1 instrukci
      neg w0,w0

      mov #8889, w1           ; perioda clk v us
                              ; = 65536 / 7,3728 a pak zahodim nizsi registr
                              ; w0 je nizsich 16b
      mul.uu w0, w1, w0
      sub w1,w2, w9
      btsc w9, #15            ; if 15. bit = 0 preskoci 1 instrukci
      neg w9,w9
      mov #1,w8               ; rozdil, ktery nas nezajima
      cpsgt w9, w8            ; if w9 > w8 tak preskoci
      bra mereni_T

      mov w1, w2
      btg LATB, #0            ; LED pro ladeni
      btg LATB, #1

      mov #2, w0
      call disp_pos           ; presun za T=

      mov w2,w0               ; ve w2 minula hodnota, presun do w0 pro vypis
      call disp_num           ; vypis hodnoty
      mov #9, w0
      call disp_pos           ; presun za T=
      bra mereni_T

__IC1Interrupt:
      push w1;
      push w0
      ;btg LATB, #0           ; LED pro testovani
      ;btg LATB, #1
      bclr IFS0, #IC1IF       ; nulovn pznaku peruen

   buf_read:                  ; doslo k preruseni je ve FIFO min 1 hodnota
      mov posledni, w0
      mov w0, minula

      mov #IC1BUF, w0         ; adresa FIFO
      mov [w0],w1
      mov w1, posledni

      btst IC1CON,#ICBNE      ; je li jeste neco
      bra Z, buf_empty
      bra buf_read
   buf_empty:
      mov #1, w0
      mov w0, update
      pop w0
      pop w1
      retfie

.bss
      update:     .space 2
      posledni:   .space 2    ; posledni ziskana hodnota
      minula:     .space 2    ; predposledni ziskana hodnota
