#include <p30f4011.h>

//hodnoty stridy 0=0, >PR2 = full->0..PR2+1->hodnot=PR2+2
#define samples 255        // pocet vzorku pro pwm
#define pi  3.14159

int act_krok = 0;          // index do tabulky predpocitanych sin hodnot

int pole[] = {
	128,131,134,137,141,144,147,150,153,156,159,162,165,168,171,174,177,180,
	183,186,188,191,194,196,199,202,204,207,209,212,214,216,219,221,223,225,
	227,229,231,233,234,236,238,239,241,242,244,245,246,247,249,250,250,251,
	252,253,254,254,255,255,255,256,256,256,256,256,256,256,255,255,255,254,
	254,253,252,251,250,250,249,247,246,245,244,242,241,239,238,236,234,233,
	231,229,227,225,223,221,219,216,214,212,209,207,204,202,199,196,194,191,
	188,186,183,180,177,174,171,168,165,162,159,156,153,150,147,144,141,137,
	134,131,128,125,122,119,115,112,109,106,103,100,97,94,91,88,85,82,79,76,
	73,70,68,65,62,60,57,54,52,49,47,44,42,40,37,35,33,31,29,27,25,23,22,20,
	18,17,15,14,12,11,10,9,7,6,6,5,4,3,2,2,1,1,1,0,0,0,0,0,0,0,1,1,1,2,2,3,
	4,5,6,6,7,9,10,11,12,14,15,17,18,20,22,23,25,27,29,31,33,35,37,40,42,44,
	47,49,52,54,57,60,62,65,68,70,73,76,79,82,85,88,91,94,97,100,103,106,
	109,112,115,119,122,125
};

/* void genPole(){         // predgenerovani pole sinus hodnot
	int i,val;
	double krok;

	krok=2*pi/(samples+1);
	for (i=0; i<=samples; i++){
		val = (sin(i*krok)+1)*((samples+1)/2);
		pole[i] = val;
	}
} */


void pwmInit() {
	OC1CON = 0x0;

	OC1RS = pole[0];       //strida
	OC1R  = pole[0];

	OC1CON = 6;            //PWM bez fail pinu
	// nastaveni preruseni timeru 2 (typ B)
	IPC1bits.T2IP = 2;     // set priority level
	IFS0bits.T2IF = 0;
	IEC0bits.T2IE = 1;
	T2CON = 0x0000;        //fosc/4,16b prescale bity<5:4>1:1=00
	PR2 = samples;         //perioda = 256

	// nastaveni preruseni timeru 3 (typ C)
	IPC1bits.T3IP = 7;     // set priority level
	IFS0bits.T3IF = 0;
	IEC0bits.T3IE = 1;
	T3CON = 0x0030;        //fosc/4, prescale bity<5:4>1:256=11
	PR3 = 225-1;//(2880*20)/samples-1, hodnota->100ms preruseni (2880-1)

	// nastaveni preruseni output compare 1
	IPC0bits.OC1IP = 3;    // set priority level
	IFS0bits.OC1IF = 0;    // Clear Output Compare 1 interrupt flag
	IEC0bits.OC1IE = 1;    // Enable Output Compare 1 interrupts

	T2CONbits.TON = 1;
	T3CONbits.TON = 1;
}


void __attribute__((interrupt))
_T2Interrupt(void) {
	
	IFS0bits.T2IF = 0; 
}


void __attribute__((interrupt))
_T3Interrupt(void) {

	IFS0bits.T3IF = 0;

	act_krok = (act_krok+1)%(samples+1);
	OC1RS = pole[act_krok];	// nova strida
	if (act_krok == 0)
		LATBbits.LATB1 = !LATBbits.LATB1;
}


void __attribute__((interrupt))
_OC1Interrupt(void) {
	//nevyvolava se
	IFS0bits.OC1IF = 0;    // smazani flagu preruseni
	LATBbits.LATB1 = !LATBbits.LATB1;
}


int delay(int time) {      //nejak nefunguje
	int i=0, j=0;

	while (j <= time) {
		while (i <= 120) {
			i++;
			asm ("nop");
			asm ("nop");
			asm ("nop");
			asm ("nop");
		}
	j++;
	i = 0;
	}
	return j;
}


int main() {

	pwmInit();

	//pro ladeni
	TRISB = 0xFFFC; // RB0, RB1 vstup
	LATB &= 0xFFFE; // nuluj RB0 a set RB1
	LATB |= 0x0002; // nuluj RB0 a set RB1

	while (1){
		delay(1000);
		LATBbits.LATB0 = !LATBbits.LATB0;
	}
}
