unit i2Strom;

interface

uses uSeznam,iStrom;

type
  t2Uzel = class;
  t2Uzel = class
   public
    constructor Create(levy: t2Uzel; pravy: t2Uzel; hodn: integer; podstrom: tStrom);
    destructor Destroy;  virtual;
    function GetHodnota: integer;
    function GetLevy: t2Uzel;
    function GetPravy: t2Uzel;
    function GetPodStrom: tStrom;
   private
    l,p: t2Uzel;
    hod: integer;
    Strom: tStrom;
  end;


  t2List = class (t2Uzel)
   public
    constructor Create(hodn: integer; podstrom: tStrom);
    destructor Destroy; virtual;
  end;

  t2PrvekFronty = class;
  t2PrvekFronty = class
   public
    constructor Create(Uzel: t2Uzel; hodn: integer);
    procedure SetPredchudce(Predchudce: t2PrvekFronty);
    function GetPredchudce: t2PrvekFronty;
    function GetHodnota: integer;
    function GetUzel: t2Uzel;
   private
    data: t2Uzel;
    hod: integer;
    next: t2PrvekFronty;
  end;

  t2Fronta = class
   public
    constructor Create;
    destructor Destroy; virtual;
    procedure Pridej(Uzel: t2Uzel; dalsiHodn:integer);
    procedure Odeber(var Uzel: t2Uzel; var dalsiHodn:integer);
    function QPrazdna: boolean;
   private
    celo, tyl: t2PrvekFronty;
    pprvku: integer;
  end;

  t2Strom = class
   public
    constructor Create(seznam: tSeznam);
    destructor Destroy;
    Function NajdiRozcesti(Xmin,Xmax: integer): t2Uzel;
    Function NajdiInterval(Xmin,Xmax,Ymin,Ymax: integer): tSeznam;
   private
    koren: t2Uzel;
    Sez: tSeznam;
  end;

implementation



{ t2Uzel }

constructor t2Uzel.Create(levy, pravy: t2Uzel; hodn: integer; podstrom: tStrom);
  begin l:= levy; p:= pravy; hod:= hodn; strom:= podStrom; end;

destructor t2Uzel.Destroy;
  begin strom.Free; end;

function t2Uzel.GetHodnota: integer;
  begin result:= hod; end;

function t2Uzel.GetLevy: t2Uzel;
  begin result:= l; end;

function t2Uzel.GetPodStrom: tStrom;
  begin result:= strom; end;

function t2Uzel.GetPravy: t2Uzel;
  begin result:= p; end;

{ t2Strom }

constructor t2Strom.Create(seznam: tSeznam);
var Fronta1, Fronta2: t2Fronta;
    tmpStrom: tStrom;
    tmpSeznam: tSeznam;
    tmpUzel,Uzel1, Uzel2: t2Uzel;
    Hod1, Hod2: integer;
    List: t2List;

begin
  if seznam.QPrazdny then exit; {seznam je prazdny - nema smysl vytvaret strom}
  sez:= seznam;
  sez.Serad(x);
  Fronta1:= t2Fronta.Create;

  {vytvoreni listu - prvni list}
  tmpSeznam:= tSeznam.Create;
  tmpSeznam.Pridej(sez.PrvniHodn);
  Hod1:= sez.GetAktualni.x;
  tmpSeznam.PripojSeznam(sez.PreskocStejne(Hod1,x));
  tmpStrom:= tStrom.Create(tmpSeznam);
  List:= t2List.Create(Hod1,tmpStrom);
  Fronta1.Pridej(List,Hod1);


  {vytvoreni listu - dalsi listy}
  while not sez.QKonec do
  begin
    tmpSeznam:= tSeznam.Create;
    tmpSeznam.Pridej(sez.DalsiHodn);
    Hod1:= sez.GetAktualni.x;
    tmpSeznam.PripojSeznam(sez.PreskocStejne(Hod1,x));
    tmpStrom:= tStrom.Create(tmpSeznam);
    List:= t2List.Create(Hod1,tmpStrom);
    Fronta1.Pridej(List,Hod1);
  end; {while}

  {vytvoreni uzlu stromu - z listu}
  Fronta2:= t2Fronta.Create;
  while not Fronta1.QPrazdna do
  begin
    Fronta1.Odeber(Uzel1,Hod1);
    tmpSeznam:= tSeznam.Create;
    if Fronta1.QPrazdna then begin Uzel2:= nil; tmpSeznam:= Uzel1.Strom.GetSeznam end else
    begin
      Fronta1.Odeber(Uzel2,Hod2);
      tmpSeznam:= tmpSeznam.SpojSeznamy(Uzel1.Strom.GetSeznam,Uzel2.GetPodStrom.GetSeznam);
    end;
    tmpStrom:= tStrom.Create(tmpSeznam);
    tmpUzel:= t2Uzel.Create(Uzel1,Uzel2,Hod1,tmpStrom);
    Fronta2.Pridej(tmpUzel,Hod2);
  end;
  fronta1.Free;
  Fronta1:= Fronta2;

 {vytvoreni uzlu stromu - z uzlu}

  while Fronta1.pprvku <> 1 do
  begin
    Fronta2:= t2Fronta.Create;
    while not Fronta1.QPrazdna do
    begin
      Fronta1.Odeber(Uzel1,Hod1);
      tmpSeznam:= tSeznam.Create;
      if not Fronta1.QPrazdna then
      begin
        Fronta1.Odeber(Uzel2,Hod2);
        tmpSeznam:= tmpSeznam.SpojSeznamy(Uzel1.Strom.GetSeznam,Uzel2.Strom.GetSeznam);
        tmpStrom:= tStrom.Create(tmpSeznam);
        tmpUzel:= t2Uzel.Create(Uzel1,Uzel2,Hod1,tmpStrom);
      end else begin tmpUzel:= Uzel1; Hod2:= Hod1 end;
      Fronta2.Pridej(tmpUzel,Hod2);
    end;
    Fronta1.Free;
    Fronta1:= Fronta2;
  end;
  Fronta1.Odeber(koren,Hod1);
end;

destructor t2Strom.Destroy;
  function ZrusUzel(Uzel: t2Uzel):t2Uzel;
  begin
    if not (Uzel is t2List) then
    begin
      ZrusUzel(Uzel.GetLevy);
      ZrusUzel(Uzel.GetPravy);
      Uzel.Free;
    end else
      Uzel.Free;
  end;
begin
  ZrusUzel(koren);
  Sez.Free;
end;

function t2Strom.NajdiInterval(Xmin, Xmax, Ymin, Ymax: integer): tSeznam;
 var u, uMin, uMax: t2Uzel;

  procedure RozhodniList(List:t2Uzel);
  begin
    if (List.GetHodnota >= Xmin) and (List.GetHodnota <= Xmax) then
     result.PripojSeznam(List.GetPodStrom.NajdiInterval(Ymin,Ymax));
  end;

begin
  result:= tSeznam.Create;
  u:= NajdiRozcesti(Xmin,Xmax);
  //pokud je u list stromu zkontroluj jesli je v hledanem intervalu
  if (u is t2List) then RozhodniList(u as t2List)
  else   //zacni prohledavat zvlast minimum a maximum
  begin
    uMin:= u.GetLevy;
    uMax:= u.GetPravy;

    //zacni hledat cestu k minimu a pritom zprcuj podstromy
    while not (uMin is t2List) do
     begin
      Case Porovnej(uMin.GetHodnota,Xmin) of
        1,0: begin if uMin.GetPravy <> nil then
              result.PripojSeznam(uMin.GetPravy.GetPodStrom.NajdiInterval(Ymin,Ymax));
              uMin:= uMin.GetLevy
             end;
        -1:  begin uMin:= uMin.GetPravy; if uMin = nil then break end;
      end; {case}
     end; {while}
   {Bud jsem na listu a musim prohledat podstrom, nebo jsem uplne vpravo a prvek muze byt nil}
   if uMin <> nil then RozhodniList(uMin as t2List);

   //najdi cestu k maximu a pritom zpracuj leve podstromy
   if uMax <> nil then begin
    while not (uMax is t2List) do
    begin
     Case Porovnej(uMax.GetHodnota,Xmax) of
       1,0: uMax:= uMax.GetLevy;
       -1: begin {jdi doprava a zpracuj levy podstrom}
             result.PripojSeznam(uMax.GetLevy.GetPodStrom.NajdiInterval(Ymin,Ymax));
             uMax:= uMax.GetPravy;
             if uMax = nil then break
           end;
     end {case}
    end; {while}
    if uMax <> nil then RozhodniList(uMax as t2List);
   end {if max}
  end; {if}
end;

function t2Strom.NajdiRozcesti(Xmin, Xmax: integer): t2Uzel;
 var uzel: t2uzel;
begin
  uzel:= koren;
  while not (uzel is t2List)
   and ((Porovnej(Xmin,uzel.GetHodnota) = Porovnej(Xmax,uzel.GetHodnota))
    or ((Porovnej(Xmin,uzel.GetHodnota) <= 0) and (Porovnej(Xmax,uzel.GetHodnota) <= 0))) do
  begin
    case Porovnej(Xmin,uzel.Gethodnota) of
      -1,0: uzel:= uzel.GetLevy;
      1:  if uzel.GetPravy = nil then uzel:= uzel.GetLevy else uzel:= uzel.GetPravy;
    end;
  end;   {while}
  result:= uzel;
end;

{ t2List }

constructor t2List.Create(hodn: integer; podstrom: tStrom);
begin l:= nil; p:= nil; strom:= podStrom; hod:= hodn end;

destructor t2List.Destroy;
begin strom.Free end;

{ t2Fronta }

constructor t2Fronta.Create;
  begin tyl:= t2PrvekFronty.Create(nil,0); celo:= tyl; pPrvku:= 0; end;

destructor t2Fronta.Destroy;
var tu: t2Uzel; ti: integer;
begin
  while not QPrazdna do Odeber(tu,ti);
  celo.Free;
end;

procedure t2Fronta.Odeber(var Uzel: t2Uzel; var dalsiHodn: integer);
var tmp: t2PrvekFronty;
begin
  if pPrvku = 1 then
  begin {zbyva posledni prvek}
    Uzel:= tyl.GetUzel;
    dalsiHodn:= tyl.GetHodnota;
    tyl.Free;
    celo.SetPredchudce(nil);
    tyl:=celo;
  end else
  begin
    tmp:= celo.GetPredchudce;
    celo.SetPredchudce(tmp.GetPredchudce); {vypusteni prvni prvku z fronty}
    Uzel:= tmp.GetUzel;
    dalsiHodn:= tmp.GetHodnota;
    tmp.Free;
  end;
  dec(pPrvku);
end;

procedure t2Fronta.Pridej(Uzel: t2Uzel; dalsiHodn: integer);
var novy: t2PrvekFronty;
begin
  novy:= t2PrvekFronty.Create(Uzel,dalsiHodn);
  tyl.SetPredchudce(novy);
  tyl:= novy;
  inc(pPrvku);
end;

function t2Fronta.QPrazdna: boolean;
  begin  result:= pPrvku = 0; end;

{ t2PrvekFronty }

constructor t2PrvekFronty.Create(Uzel: t2Uzel; hodn: integer);
  begin data:= uzel; hod:= hodn; next:= nil; end;

function t2PrvekFronty.GetHodnota: integer;
 begin result:= hod; end;

function t2PrvekFronty.GetPredchudce: t2PrvekFronty;
 begin result:= next; end;

function t2PrvekFronty.GetUzel: t2Uzel;
 begin result:= data; end;

procedure t2PrvekFronty.SetPredchudce(Predchudce: t2PrvekFronty);
 begin next:= Predchudce; end;

end.
