unit iStrom;

interface

uses uSeznam;

type
  tUzel = class;
  tUzel = class
   public
    constructor Create(levy: tUzel; pravy: tUzel; hodn: integer);
    function GetHodnota: integer;
    function GetLevy: tUzel;
    function GetPravy: tUzel;
   private
    l,p: tUzel;
    hod: integer;
  end;

  tList = class (tUzel)
   private
    l,p: ptrCell;
   public
    constructor Create(levy: ptrCell; pravy: ptrCell; hodn: integer);
    function GetLevy: ptrCell;
    function GetPravy: ptrCell;
  end;

  tPrvekFronty = class;
  tPrvekFronty = class
   public
    constructor Create(Uzel: tUzel; hodn: integer);
    procedure SetPredchudce(Predchudce: tPrvekFronty);
    function GetPredchudce: tPrvekFronty;
    function GetHodnota: integer;
    function GetUzel: tUzel;
   private
    data: tUzel;
    hod: integer;
    next: tPrvekFronty;
  end;

  tFronta = class
   public
    constructor Create;
    destructor Destroy;
    procedure Pridej(Uzel: tUzel; dalsiHodn:integer);
    procedure Odeber(var Uzel: tUzel; var dalsiHodn:integer);
    function QPrazdna: boolean;
   private
    celo, tyl: tPrvekFronty;
    pprvku: integer;
  end;

  tStrom = class
   public
    constructor Create(Seznam: tSeznam);
    destructor Destroy;
    Function NajdiInterval(Ymin,Ymax: integer): tSeznam;
    Function NajdiMin(Ymin: integer): ptrCell;
    function GetSeznam: tSeznam;
    function GetKoren: tUzel;
   private
    koren: tUzel;
    S: tSeznam;
  end;

implementation

{ tUzel }

constructor tUzel.Create(levy, pravy: tUzel; hodn: integer);
 begin l:= levy; p:= pravy; hod:= hodn; end;

function tUzel.GetHodnota: integer;
 begin result:= hod; end;

function tUzel.GetLevy: tUzel;
 begin result:= l; end;

function tUzel.GetPravy: tUzel;
 begin result:= p; end;

{ tStrom }

function tStrom.NajdiInterval(Ymin, Ymax: integer): tSeznam;
var p: ptrCell;
begin
  p:= NajdiMin(Ymin);
  result:= tSeznam.Create;
  if p = nil then exit;
  if (p^.point.y > Ymax) or (p^.point.y < Ymin) then  exit;
  S.SetAktualni(p);
  result.Pridej(p^.point);
  while (p^.next^.point.y <= Ymax) and (not S.QKonec) do
   begin p:= s.Dalsi; result.Pridej(p^.point) end;
end;

function tStrom.NajdiMin(Ymin: integer): ptrCell;
var uz: tUzel; p: ptrCell;
begin
  uz:= koren;
  while not (uz is tList) do
  begin
    if uz.hod >= Ymin then uz:= uz.l
     else uz:= uz.p;
  end;
  if uz.hod >= Ymin then p:= (uz as tList).GetLevy
   else p:= (uz as tList).GetPravy;
   result:= p;
end;

constructor tStrom.Create(Seznam: tSeznam);
var Fronta1,Fronta2: tFronta;
    tmp: tList;
    lCell,pCell: ptrCell;
    tmpUzel,tmpUzel1,tmpUzel2: tUzel;
    tmpHod1,tmpHod2: integer;

begin
  S:= Seznam;
  if S.QPrazdny then exit; {Pokud je seznam prazdny nena smysl vytvaret strom}
  Fronta1:= tFronta.Create;
  S.Serad(y);

  {vytvoreni listu stromu - vytvoreni prvniho listu}
  lCell:= S.Prvni;
  S.PreskocStejne(lCell^.point.y,y);
  if not S.QKonec then pCell:= S.Dalsi else pCell:= nil; {nacti praveho, pokud neni tak nil}
  tmp:= tList.Create(lCell,pCell,lCell^.point.y); {vytvori List}
  if pCell = nil then Fronta1.Pridej(tmp,lCell^.point.y) else {prida ho do fronty}
  begin
    Fronta1.Pridej(tmp,pCell^.point.y);
    S.PreskocStejne(pCell^.point.y,y)
  end;
  {vytvoreni listu stromu - vytvoreni dalsich listu}
  while not S.QKonec do
  begin
    lCell:= S.Dalsi;
    S.PreskocStejne(lCell^.point.y,y);
    if S.QKonec then pCell:= nil else pCell:= S.Dalsi;
    tmp:= tList.Create(lCell,pCell,lCell^.point.y);
    if S.QKonec then Fronta1.Pridej(tmp,0) else
    begin
      Fronta1.Pridej(tmp,pCell^.point.y);
      S.PreskocStejne(pCell^.point.y,y);
    end {if}
  end;

 {vytvoreni uzlu stromu}

 while Fronta1.pprvku <> 1 do begin
  Fronta2:= tFronta.Create;
  while not Fronta1.QPrazdna do
  begin
    Fronta1.Odeber(tmpUzel1,tmpHod1);
    if not Fronta1.QPrazdna then
    begin
      Fronta1.Odeber(tmpUzel2,tmpHod2);
      tmpUzel:= tUzel.Create(tmpUzel1,tmpUzel2,tmpHod1);
    end else begin tmpUzel:= tmpUzel1; tmpHod2:= tmpHod1 end;
    Fronta2.Pridej(tmpUzel,tmpHod2);
  end; {druhy while}
  Fronta1.Free;
  Fronta1:= Fronta2;
 end; {prvni while}
 Fronta1.Odeber(koren,tmpHod1);
end;


function tStrom.GetSeznam: tSeznam;
 begin result:= s end;

function tStrom.GetKoren: tUzel;
begin result:= koren end;

destructor tStrom.Destroy;
  function ZrusUzel(Uzel: tUzel):tUzel;
  begin
    if not (Uzel is tList) then
    begin
      ZrusUzel(Uzel.GetLevy);
      ZrusUzel(Uzel.GetPravy);
      Uzel.Free;
    end else
      Uzel.Free;
  end;
begin
  ZrusUzel(koren);
  S.Free;
end;

{ tList }

constructor tList.Create(levy, pravy: ptrCell; hodn: integer);
begin l:= levy; p:= pravy; hod:= hodn; end;

function tList.GetLevy: ptrCell;
 begin result:= l; end;

function tList.GetPravy: ptrCell;
 begin result:= p; end;

{ tPrvekFronty }

constructor tPrvekFronty.Create(Uzel: tUzel; hodn: integer);
 begin data:= uzel; hod:= hodn; next:= nil; end;

function tPrvekFronty.GetHodnota: integer;
 begin result:= hod; end;

function tPrvekFronty.GetPredchudce: tPrvekFronty;
 begin result:= next; end;

function tPrvekFronty.GetUzel: tUzel;
 begin result:= data; end;

procedure tPrvekFronty.SetPredchudce(Predchudce: tPrvekFronty);
 begin next:= Predchudce; end;

{ tFronta }

constructor tFronta.Create;
begin
  tyl:= tPrvekFronty.Create(nil,0);
  celo:= tyl;
  pPrvku:= 0;
end;

destructor tFronta.Destroy;
var tu: tUzel; ti: integer;
begin
  while not QPrazdna do Odeber(tu,ti);
  celo.Free;
end;

procedure tFronta.Odeber(var Uzel: tUzel; var dalsiHodn: integer);
var tmp: tPrvekFronty;
begin
  if pPrvku = 1 then
  begin {zbyva posledni prvek}
    Uzel:= tyl.GetUzel;
    dalsiHodn:= tyl.GetHodnota;
    tyl.Free;
    celo.SetPredchudce(nil);
    tyl:=celo;
  end else
  begin
    tmp:= celo.GetPredchudce;
    celo.SetPredchudce(tmp.GetPredchudce); {vypusteni prvni prvku z fronty}
    Uzel:= tmp.GetUzel;
    dalsiHodn:= tmp.GetHodnota;
    tmp.Free;
  end;
  dec(pPrvku);
end;

procedure tFronta.Pridej(Uzel: tUzel; dalsiHodn: integer);
var novy: tPrvekFronty;
begin
  novy:= tPrvekFronty.Create(Uzel,dalsiHodn);
  tyl.SetPredchudce(novy);
  tyl:= novy;
  inc(pPrvku);
end;

function tFronta.QPrazdna: boolean;
 begin  result:= pPrvku = 0; end;


end.
