unit test;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, ExtCtrls,
  uSeznam,iStrom, i2Strom;

const
  HLEDANE = 1;
  ZADANE = 0;  

type
  TForm1 = class(TForm)
    SpinEditX: TSpinEdit;
    SpinEditY: TSpinEdit;
    Button1: TButton;
    Memo1: TMemo;
    Image1: TImage;
    Label1: TLabel;
    Button3: TButton;
    Button4: TButton;
    Memo2: TMemo;
    MinY: TSpinEdit;
    MaxY: TSpinEdit;
    Button7: TButton;
    Label2: TLabel;
    Label3: TLabel;
    MinX: TSpinEdit;
    MaxX: TSpinEdit;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Button8: TButton;
    Label7: TLabel;
    Label8: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    RadioGroup1: TRadioGroup;
    Edit1: TEdit;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
  private
    { Private declarations }
    procedure Vykresli(BodyVSeznamu: tSeznam; typ: integer);
    procedure Seradit(var BodyVSeznamu: tSeznam);
    procedure VycistiObr;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation




var Seznam: tSeznam;
    Strom2D: t2Strom;
{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
var p: tBod;
begin
  p.x:= SpinEditX.Value;
  p.y:= SpinEditY.Value;
  Seznam.Pridej(p);
  Vykresli(Seznam,ZADANE);
  Button7.Enabled:= true;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin Seznam:= tSeznam.Create; end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  Strom2D.Free;
  Seznam.Free;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Seradit(Seznam);
  Vykresli(Seznam,ZADANE);
end;

procedure TForm1.Button4Click(Sender: TObject);
var i: integer;
    p: tBod;
begin
  randomize;
  Seznam.Free;
  Seznam:= tSeznam.Create;
  for i:= 1 to StrToInt(Edit1.Text) do begin
    p.x:= Random(100);
    p.y:= Random(100);
    Seznam.Pridej(p);
  end;
  Seradit(Seznam);
  Vykresli(Seznam,ZADANE);
  Button7.Enabled:= true;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  Button8.Enabled:= true;
  Strom2D:= t2Strom.Create(seznam);
end;

procedure TForm1.Button8Click(Sender: TObject);
 var NalezeneBody: tSeznam;
begin
  if (MinX.Value > MaxX.Value) or (MinY.Value > MaxY.Value) then
   MessageDlg('patn zadan hledan interval. Horn mez Max mus bt men ne doln mez Min. Prosm opravta zadn', mtInformation,[mbOk], 0)
  else begin
   Vykresli(Seznam,ZADANE);
   //nalezeni intervalu
   NalezeneBody:= Strom2D.NajdiInterval(MinX.Value,MaxX.Value,MinY.Value,MaxY.Value);
   Seradit(NalezeneBody);
   Vykresli(NalezeneBody,HLEDANE);
   NalezeneBody.Free;
  end
end;

procedure TForm1.VycistiObr;
begin
 with Image1.Canvas do begin
  Lock;
  Pen.Color:=clWhite;
  Brush.Color:=clWhite;
  Rectangle(0,0,Image1.Width,Image1.Height);
  Unlock;
 end;
end;


procedure TForm1.Vykresli(BodyVSeznamu: tSeznam; typ: integer);
 const K = 2;
 var Memo: tMemo; barva: tColor; PB: tLabel; p: tBod;
begin
  case typ of
    0: begin Memo:= Memo1; barva:= clBlue; PB:= Label1; VycistiObr; end; {zadane body}
    1: begin Memo:= Memo2; barva:= clRed; PB:= Label12 end; {nalezene body}
  end;

  Memo.Clear;
  PB.Caption:= IntToStr(BodyVSeznamu.PocPrvku);

  if BodyVSeznamu.QPrazdny then 
    Memo.Lines.Add('Interval je prazdny')
  else
  begin
   image1.Canvas.Brush.Color:= barva;
   image1.Canvas.Pen.Color:= barva;
   p:= BodyVSeznamu.PrvniHodn;
   Memo.Lines.BeginUpdate;
   Memo.Lines.Add('x:' + intToStr(p.x) + ', y:'+intToStr(p.y));
   image1.Canvas.Rectangle(round(K*p.x),round(K*p.y),round(K*(p.x+1)),round(K*(p.y+1)));
   while not BodyVSeznamu.QKonec do begin
    p:= BodyVSeznamu.DalsiHodn;
    Memo.Lines.Add('x:' + intToStr(p.x) + ', y:'+intToStr(p.y));
    image1.Canvas.Rectangle(round(K*p.x),round(K*p.y),round(K*(p.x+1)),round(K*(p.y+1)));
   end;
   Memo.Lines.EndUpdate;
  end; {if}
end;

procedure TForm1.Seradit(var BodyVSeznamu: tSeznam);
begin
 if not BodyVSeznamu.QPrazdny then
  case RadioGroup1.ItemIndex of
    0: BodyVSeznamu.Serad(x);
    1: BodyVSeznamu.Serad(y);
    2: {neradit};
  end;
end;

end.
