-- The adder is a combinational circuit that has 3 inputs and 2 outputs.
-- Inputs: two 8-bit operands A, B and one 1-bit carry-in Cin.
-- Outputs: one 8-bit result S and one 1-bit carry-out Cout.
--
-- The adder itself consists of eight 1-bit full adders (implemented as expressions).The i-th bit of the result is computed as follows.
--
-- Si = Ai xor Bi xor Ci-1 -- exclusive or
--
-- Ci = M3(Ai, Bi, Ci-1) -- majority function
--
-- a) Implement the adder as a VHDL entity ADDER containing 1 process and 1 function.
-- The adder contains 1 process that computes individual bits of the result (in a for cycle).
-- Instead of declaring the Ci as a vector, use a single variable C, which represents the intermediate carry.

-- Implement the majority function M3 as a VHDL function Maj3 that takes 3 arguments (x, y, z) of type std_logic and returns std_logic.

library ieee;
use ieee.std_logic_1164.all;

entity ADDER is
  port (
    A, B : in std_logic_vector(7 downto 0);
    CIN  : in std_logic;
    S    : out std_logic_vector(7 downto 0);
    COUT : out std_logic
  );
end ADDER;


architecture ADDER_BODY of ADDER is
    
   function Maj3(x, y, z: std_logic) return std_logic is
   begin
      return  (x and z) or (y and z) or (x and y);
   end Maj3;    
    
begin
    
   process(A,B,CIN)
         variable c : std_logic; 
   
   begin
      c := CIN;
      
      for i in 0 to 7 loop
         S(i) <= A(i) xor B(i) xor c;
         c := Maj3(A(i), B(i), c); -- compute new carry
      end loop;
      
      COUT <= c;
   end process;
        
end ADDER_BODY;
