-- Michal Trs, trsm1@fel.cvut.cz

-- b) Write a tester entity ADDER_TEST, which will test the correct function of the adder. Use assert to check the results.

library ieee;
use ieee.std_logic_1164.all;
use ieee.std_logic_arith.all;

entity ADDER_TEST is
end ADDER_TEST;

architecture TESTBENCH of ADDER_TEST is
   


-- declare the component
component ADDER
  port (
    a, b : in std_logic_vector(7 downto 0);
    cin  : in std_logic;
    s    : out std_logic_vector(7 downto 0);
    cout : out std_logic
  );
end component;

signal t_a : std_logic_vector(7 downto 0);
signal t_b : std_logic_vector(7 downto 0);
signal t_s : std_logic_vector(7 downto 0);
signal t_cin  : std_logic;
signal t_cout : std_logic;

begin

  i_adder: ADDER port map (
     a => t_a,
     b => t_b,
     s => t_s,
     cin  => t_cin,
     cout => t_cout
  ); 

  -- test process - assign some test values
  tst: process
    -- variable ...
  begin
    -- initialize signals
    t_a <= "00000000";
    t_b <= "00000000";
    t_cin <= '0';
    wait for 10 ns;
    
    -- convert the numbers to an 8-bit vector
    -- 1st test vector  
    t_a <= conv_std_logic_vector(12, 8); 
    t_b <= conv_std_logic_vector(34, 8); 
    t_cin <= '0';
    wait for 50 ns;
     assert conv_std_logic_vector(46, 9) = t_cout & t_s
		    report "Adder malfunction"
			 severity failure;
			 
	 -- 2nd test vector
	 t_a <= conv_std_logic_vector(12, 8); 
    t_b <= conv_std_logic_vector(34, 8); 
    t_cin <= '1';
    wait for 50 ns;
     assert conv_std_logic_vector(47, 9) = t_cout & t_s
		    report "Adder malfunction"
			 severity failure;
			 
	 -- 3th test vector
	 t_a <= conv_std_logic_vector(-15, 8); 
    t_b <= conv_std_logic_vector(30, 8); 
    t_cin <= '0';
    wait for 50 ns;
     assert conv_std_logic_vector(256 + 15, 9) = t_cout & t_s
		    report "Adder malfunction"
			 severity failure;

	 -- 4th test vector
	 t_a <= conv_std_logic_vector(-12, 8); 
    t_b <= conv_std_logic_vector(34, 8); 
    t_cin <= '1';
    wait for 50 ns;
    assert conv_std_logic_vector(256 + 23, 9) = t_cout & t_s
		    report "Adder malfunction"
			 severity failure;
			 
	 -- 5th test vector
	 t_a <= conv_std_logic_vector(121, 8); 
    t_b <= conv_std_logic_vector(160, 8); 
    t_cin <= '0';
    wait for 50 ns;
     assert conv_std_logic_vector(281, 9) = t_cout & t_s
		    report "Adder malfunction"
			 severity failure;			 
	 
	 wait;
  end process; -- tst 
end TESTBENCH;
