-- Michal Trs, trsm1@fel.cvut.cz

-- The counter is a sequential circuit with 4 inputs and 1 output.
--
-- Data input: n-bit data input I.
-- Control inputs: LOAD, CE, CLK
-- Output: 1-bit output ZERO.
--
-- This is a 3-bit (n-bit) down counter with count enable (CE) and load (LOAD).
-- 
-- Implement the counter using 1 process. All signals and variables are either std_logic or std_logic_vector (do not use integers). Use the std_logic_unsigned package for the arithmetic operations on std_logic_vector (like A <= B - C).
--
-- The zero-detection output (ZERO) will be '1' whenever the count signal/variable is all zeros, '0' otherwise.
-- 
-- All inputs are synchronous to the clock.
-- 
-- Write a VHDL entity COUNTER implementing the counter.

library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity COUNTER is
 port(
   I:    in std_logic_vector(2 downto 0);
   LOAD: in std_logic;
   CE:   in std_logic;
   CLK:  in std_logic;
   ZERO:out std_logic
 );
end COUNTER;

architecture COUNTER_BODY of COUNTER is
   signal data: std_logic_vector(2 downto 0);
begin

   cnt:process(CLK, CE, LOAD)
   begin
      if CLK = '1' and CLK'event then
         if LOAD = '1' then
            data <= I; 
         elsif CE = '1' then
            data <= data - 1;  
         end if;    
      end if;
   end process;
   
   ZERO <= '1' when data = "000"
      else '0';
                
end COUNTER_BODY;