-- Michal Trs, trsm1@fel.cvut.cz

-- Complete the multiplier so that it works according to the description.
-- 
-- Interface:
-- Bidirectional (3-state) 8-bit port DATA
-- Inputs: START, CLK, ARES (asynchronous reset)
-- Output: READY
-- 
-- Note: Do not forget to properly clear the C register before each multiplication. The ARES input (not shown in the picture) is fed to the controller only.
-- 
-- Write a VHDL entity MULT implementing the multiplier.
--
--
-- Buffers
-- Two 8-bit 3-state buffers are necessary to place the high and low parts of the result to the DATA bus.
--
-- Implement the buffers using conditional signal assignment in parallel environment. 
-- To "disconnect" from the bus, store a vector of  'Z's, which represent the 3rd state. 
-- You do not need to create a separate entity for the buffers, just place the statements into the multiplier architecture.
 
library IEEE;
use IEEE.std_logic_1164.all;
use IEEE.std_logic_unsigned.all;

entity MULT is
   port(
      CLK   : in std_logic;
      ARES  : in std_logic;
      START : in std_logic;
      DATA  : inout std_logic_vector(7 downto 0);
      READY : out std_logic
   );
end MULT;


architecture TOP_LEVEL of MULT is

   component REG
    port(
      I:    in   std_logic_vector(7 downto 0);
      CLK:  in   std_logic;
      CE:   in   std_logic;
      RST:  in   std_logic;
      O:    out  std_logic_vector(7 downto 0) );
   end component;
   
   component SHIFT_REG
    port(
      I:    in std_logic_vector(7 downto 0);
      SI:   in std_logic;
      LOAD: in std_logic;
      SHIFT:in std_logic;
      CLK:  in std_logic;
      O:   out std_logic_vector(7 downto 0);
      SO:  out std_logic );    
   end component; 

   component AND_BLOCK
     port (
       A:   in std_logic_vector(7 downto 0);
       SEL: in std_logic;    
       Y : out std_logic_vector(7 downto 0) );
   end component;
   
   component ADDER
     port (
       A, B : in std_logic_vector(7 downto 0);
       CIN  : in std_logic;
       S    : out std_logic_vector(7 downto 0);
       COUT : out std_logic );
   end component;

   component SHIFTER
     port (
       SI: in std_logic;
       I : in std_logic_vector(7 downto 0);
       O : out std_logic_vector(7 downto 0);
       SO: out std_logic );
   end component; 

   component COUNTER
    port(
      I:    in std_logic_vector(2 downto 0);
      LOAD: in std_logic;
      CE:   in std_logic;
      CLK:  in std_logic;
      ZERO:out std_logic );
   end component;
   
   component CONTROLLER
    port(
      CLK      : in std_logic;
      ARES     : in std_logic;
      START    : in std_logic;
      ZERO     : in std_logic;
      DO_MULT  : out std_logic;
      LOAD_A   : out std_logic;
      LOAD_B   : out std_logic;
      STORE_C  : out std_logic;
      STORE_D  : out std_logic;
      LOAD_CNT : out std_logic );
   end component;
   
   -- interconection signals
   signal do_mult, load_a, load_b, store_c, store_d, load_cnt, zero  : std_logic;
   signal b_out, shifter_carry, adder_carry  : std_logic;
   signal a_out, c_out, d_out, and_out, adder_out,  shifter_out  : std_logic_vector(7 downto 0);         

begin

   regA: REG port map(
      I     => DATA,
      CLK   => CLK,
      CE    => load_a,
      RST   => ARES,
      O     => a_out
   );

   regB: SHIFT_REG port map(
      I     => DATA,
      SI    => '0',
      LOAD  => load_b,
      SHIFT => do_mult,
      CLK   => CLK,
      O     => open,
      SO    => b_out
   );    

   regC: REG port map(
      I     => shifter_out,
      CLK   => CLK,
      CE    => do_mult,
      RST   => load_b,
      O     => c_out
   );    

   regD: SHIFT_REG port map(
      I     => (others => '0'),
      SI    => shifter_carry,
      LOAD  => '0',
      SHIFT => do_mult,
      CLK   => CLK,
      O     => d_out,
      SO    => open
   );
   
   and_blk: AND_BLOCK port map(
      A     => a_out,
      SEL   => b_out,
      Y     => and_out
   );
   
   adder_blk: ADDER port map(
      A    => and_out,    
      B    => c_out,
      CIN  => '0',
      S    => adder_out,
      COUT => adder_carry 
   );
   
   shifter_blk: SHIFTER port map(
      SI    => adder_carry,
      I     => adder_out,
      O     => shifter_out,
      SO    => shifter_carry
   );

   counter_blk: COUNTER port map(
      I     => "111",
      LOAD  => load_cnt,
      CE    => do_mult,
      CLK   => CLK,
      ZERO  => zero
   );
   
   control_blk: CONTROLLER port map(
      CLK      => CLK,
      ARES     => ARES,
      START    => START,
      ZERO     => zero,
      DO_MULT  => do_mult,
      LOAD_A   => load_a,
      LOAD_B   => load_b,
      STORE_C  => store_c,
      STORE_D  => store_d,
      LOAD_CNT => load_cnt
   );

   DATA <= c_out when store_c = '1' 
      else d_out when store_d = '1'
      else (others => 'Z');
      
   READY <= '1' when (store_c = '1') or (store_d = '1')
      else  '0';

end TOP_LEVEL;

