-- Michal Trs, trsm1@fel.cvut.cz

-- Write a VHDL testbench SHIFT_REG_TEST to test the hold, shift and load operations of the shift register.

library IEEE;
use ieee.std_logic_1164.all;

entity SHIFT_REG_TEST is
end SHIFT_REG_TEST;

architecture TESTBENCH of SHIFT_REG_TEST is
   component SHIFT_REG is
    port(
      I:    in std_logic_vector(7 downto 0);
      SI:   in std_logic;
      LOAD: in std_logic;
      SHIFT:in std_logic;
      CLK:  in std_logic;
      O:   out std_logic_vector(7 downto 0);
      SO:  out std_logic
    );    
   end component;
   
   signal t_i:    std_logic_vector(7 downto 0);
   signal t_si:   std_logic;
   signal t_load: std_logic;
   signal t_shift:std_logic;
   signal t_clk:  std_logic := '0';
   signal t_o:    std_logic_vector(7 downto 0);
   signal t_so:   std_logic;
   
   constant T:    time := 40 ns;
   
begin    
   uut: SHIFT_REG port map(
      t_i, t_si, t_load, t_shift, t_clk, t_o, t_so
   ); 
   
   t_clk <= not t_clk after T/2;
   
   tst: process
   begin
      -- init
      t_i <= (others => '0');
      t_si <= '0';
      t_load <= '0';
      t_shift <= '0';
      wait for 2*T;
      
      -- test
      t_i <= "11110000";
      t_si <= '0';
      t_load <= '1';
      wait for T;
      t_load <= '0';
      
      assert t_o = "11110000"
      report "Spatne nahrana hodnota"
			 severity failure;

      
      
      
      t_shift <= '1';
      wait for 5*T;
      t_shift <= '0';
      
      assert t_o = "00000111"
      report "Spatne siftuje"
			 severity failure;
      
      t_i <= "10001000";
      t_si <= '0';
      t_load <= '1';
      wait for T;
      t_load <= '0';
      wait for 5*T;
      
      assert t_o = "10001000"
      report "Nepamatuje hodnotu"
			 severity failure;
      
      t_shift <='1';
      wait for 4*T;
      
      assert t_o = "00001000"
      report "Nesiftuje"
			 severity failure;
      
      t_si <= '1';
      wait for 2*T;
      
      assert t_o = "11000010"
      report "Nesiftuje s prenosem"
			 severity failure;
      
      t_si <= '0';
      wait for 9*T; 
      
      assert t_o = "00000000"
      report "Nesiftuje"
			 severity failure;
       
       
      wait; 
   end process;
    
end TESTBENCH;