;**************************************************************************
;  
;  Funkce void student() v asembleru (verze pro NASM)
;  --------------------------------------------------
;   
;  Tento zdrojovy kod obsahuje nezbytnou
;  cast implementace funkce student(), ktera bude 
;  prilinkovana k main.c. V casti "... zde doplnte instrukce ..."
;  muze student dopsat jakekoliv MMX, SSE, SSE2, SSE3 instrukce podle 
;  zadaneho ukolu. 
;      
;  *** Ladici funkce pro MMX, SSE a 3DNow! ***
;  
;  Zobrazeni MMX registru (MMX, 3DNow!):
 
	EXTERN print_mm_regs_pb
	EXTERN print_mm_regs_pw
	EXTERN print_mm_regs_pd
	EXTERN print_mm_regs_pq
	EXTERN print_mm_regs_fp
     
;  Funkce vytisknou vsechny MMX registry ve formatu packet byte(pb), packet
;  word (pw), packet double word (pd), packet quad word (pq) a single-precision
;  FP (fp). Vsechny funkce jsou bez parametru. Funkce _print_mm_regs_fp ma smysl 
;  pouze pro 3DNow!. Volani z asembleru napr. call _print_mm_regs_pd. Format 
;  vystupu (hexadecimalne, dekadicky se znamenkem a bez znamenka) je mozno 
;  ovlivnit parametrem spousteneho programu. Napr. ./main -cl -x zajisti
;  vystup v sestnactkove soustave. 
;   
;  Zobrazeni jednoho MMX registru:
;  
;  Format packet byte (pb):
;
	EXTERN print_mm0_pb
	EXTERN print_mm1_pb
	EXTERN print_mm2_pb
	EXTERN print_mm3_pb
	EXTERN print_mm4_pb
	EXTERN print_mm5_pb
	EXTERN print_mm6_pb
	EXTERN print_mm7_pb
;	
;  Format packet word (pw):
;
	EXTERN print_mm0_pw
	EXTERN print_mm1_pw
	EXTERN print_mm2_pw
	EXTERN print_mm3_pw
	EXTERN print_mm4_pw
	EXTERN print_mm5_pw
	EXTERN print_mm6_pw
	EXTERN print_mm7_pw
;	
;  Format packet dword (pd):
;
	EXTERN print_mm0_pd
	EXTERN print_mm1_pd
	EXTERN print_mm2_pd
	EXTERN print_mm3_pd
	EXTERN print_mm4_pd
	EXTERN print_mm5_pd
	EXTERN print_mm6_pd
	EXTERN print_mm7_pd
;	
;  Format packet qword (pq):
;
	EXTERN print_mm0_pq
	EXTERN print_mm1_pq
	EXTERN print_mm2_pq
	EXTERN print_mm3_pq
	EXTERN print_mm4_pq
	EXTERN print_mm5_pq
	EXTERN print_mm6_pq
	EXTERN print_mm7_pq
;
;
;  Zobrazeni XMM registru (jen SSE, SSE2, SSE3)	
;
	EXTERN print_xmm_regs
;  
;  Tato funkce vytiskne vsechny XMM registry v single-precision FP formatu. 
;  Funkce nema zadne parametry.
;
;  Zobrazeni jednoho XMM registru
;
	EXTERN print_xmm0
	EXTERN print_xmm1
	EXTERN print_xmm2
	EXTERN print_xmm3
	EXTERN print_xmm4
	EXTERN print_xmm5
	EXTERN print_xmm6
	EXTERN print_xmm7 
;  
;  Tato funkce vytiskne jeden XMM registr v single-precision FP formatu. 
;  Funkce nema zadne parametry. Priklad volani z asembleru call _print_xmm0.
;  
;  *** Graficke funkce ***
;  
;  Makro  LOAD_RGB_IMAGE fn, w, h, im
;  
;  Toto makro nahraje obrazek ze souboru fn. Velikost obrazku je urcena 
;  velikosti obrazku v souboru. Velikost se uklada do promennych w a h typu
;  int. Nahrany obrazek se ulozi po radcich do pole im v RGB formatu 00bbggrr
;  (32 bitu na pixel). Velikost pole im musi byt dostatecna
;  pro ulozeni celeho obrazku (nekontroluje se). Pokud je parametr im = 0 (null),
;  pak se naplni pouze promenne w, h. To se da vyuzit ke zjisteni velikosti 
;  obrazku a naslednou kontrolu nebo alokaci pole. 
;  
;  Priklad pouziti:
;  
;    		SEGMENT .data 
;
; width:	DD 0
; height: 	DD 0
;
; image:	RESD 100*100	
;        
;		SEGMENT .text
;		...
;		LOAD_RGB_IMAGE num, width, height, image
;		...
;	 
;        
;  Makro  LOAD_GRAY_IMAGE fn, w, h, im
;  
;  Toto makro nahraje obrazek ze souboru fn. Velikost obrazku je urcena 
;  velikosti obrazku v souboru. Velikost se uklada do promennych w a h typu
;  int. Nahrany obrazek se ulozi po radcich do pole im ve formatu 8 bitu/pixel 
;  (256 urovni sedi). Pozor ! obrazek v souboru muze byt pouze barevny (RGB Truecolor). 
;  Velikost pole im musi byt dostatecna pro ulozeni celeho obrazku (nekontroluje se).
;  Pokud je parametr im = 0 (null), pak se naplni pouze promenne w, h. 
;  To se da vyuzit ke zjisteni velikosti obrazku a naslednou kontrolu nebo alokaci pole.
;
;  Priklad pouziti:
;  
;    		SEGMENT .data  
;
; width:	DD 0
; height: 	DD 0
;
; image:	RESB 100*100	
;        
;		SEGMENT .text
;		...
;		LOAD_GRAY_IMAGE num, width, height, image
;		...
;
;  		Makro SHOW_RGB_IMAGE num, w, h, im      	
;   
;********************************************************************************
;    
	BITS 32      
;	
;	Makra 
;
	EXTERN load_rgb_image
	EXTERN load_gray_image
	EXTERN show_rgb_image
	EXTERN show_gray_image
	
;       LOAD_RGB_IMAGE fn, w, h, im
%macro  LOAD_RGB_IMAGE 4
	sub esp, 0x10
	mov dword [esp], %1
	mov dword [esp+0x4], %2
	mov dword [esp+0x8], %3
	mov dword [esp+0xC], %4
	call	load_rgb_image 
%endmacro

;	LOAD_GRAY_IMAGE fn, w, h, im
%macro	LOAD_GRAY_IMAGE 4
	sub esp, 0x10
	mov dword [esp], %1
	mov dword [esp+0x4], %2
	mov dword [esp+0x8], %3
	mov dword [esp+0xC], %4
	call	load_gray_image 
%endmacro

;	SHOW_RGB_IMAGE num, w, h, im
%macro 	SHOW_RGB_IMAGE 4
	sub esp, 0x10
	mov dword [esp], %1
	mov eax, dword [%2]
	mov dword [esp+0x4], eax
	mov eax, dword [%3]
	mov dword [esp+0x8], eax
	mov dword [esp+0xc], %4
	call	show_rgb_image
%endmacro

;	SHOW_GRAY_IMAGE num, w, h, im
%macro 	SHOW_GRAY_IMAGE 4
	sub esp, 0x10
	mov dword [esp], %1
	mov eax, dword [%2]
	mov dword [esp+0x4], eax
	mov eax, dword [%3]
	mov dword [esp+0x8], eax
	mov dword [esp+0xc], %4
	call	show_gray_image
%endmacro
	
;********************************************************************************
;
;	Inicializovane promenne
;
	SEGMENT .data

fn_bg: 	DB "background.bmp",0
fn_fg: 	DB "foreground.bmp",0

fg_w:	DD 0
fg_h:	DD 0

bg_w:	DD 0
bg_h:	DD 0

keyc	DB 00h, 80h,80h, 00h, 00h, 80h, 80h, 00h


xa:	DD 1.1, 1.2, 1.3, 1.4
xb:	DD 2.1, 2.2, 2.3, 2.4




;	Neinicializovane promenne	
;	
	SEGMENT .bss

;
fg_image:  RESD (200 * 200) ; obrazek 200 x 200 pixelu 
fg_mask:   RESD (200 * 200) ; obrazek 200 x 200 pixelu 
bg_image:  RESD (200 * 200) ; obrazek 200 x 200 pixelu 
bg_mask:   RESD (200 * 200) ; obrazek 200 x 200 pixelu 

;
; 	Program
;		
     	SEGMENT .text
;
;	Export funkce student()
;
	GLOBAL student

student: 
 	; Prolog
       	push   ebp
        mov    ebp, esp

        ; Telo funkce
	
	; Nulovani MMX registru 

	pxor mm0, mm0
	pxor mm1, mm1
	pxor mm2, mm2
	pxor mm3, mm3
	pxor mm4, mm4
	pxor mm5, mm5
	pxor mm6, mm6
	pxor mm7, mm7

	; ... zde napiste instrukce ...
	
	; Priklad: 1 
	; (odkomentujte nasledujici 4 radky, prelozte a
	; spustte s parametrem -gr. [./main -gr])
	; 
	LOAD_RGB_IMAGE fn_fg, fg_w, fg_h, fg_image
	LOAD_RGB_IMAGE fn_bg, bg_w, bg_h, bg_image
	
	
	; maska
	;;;;;;;;;;;;;;;;;;;;;;;;;;
	mov ecx,200*200/2
	mov esi,fg_image  ; adresa obr
	mov edi,fg_mask	  ; vysledna maska	
	movq mm1,[keyc]			
maskg:	movq mm0,[esi]
	pcmpeqd mm0,mm1
	movq [edi],mm0	
	add esi,8
	add edi,8
	loop maskg	
	
	; "background" and "maska"
	mov ecx,200*200/2
	mov esi,bg_image  ; background
	mov eax,fg_image  ; foreground
	mov edi,fg_mask	  ; maska
andbm:	movq mm0,[esi]
	movq mm1,[eax]
	movq mm2,[edi]

	
	pand mm0,mm2
	pandn mm2,mm1
	por mm0,mm2
	
	movq [edi],mm0
	add esi,8
	add edi,8
	add eax,8
	loop andbm
	     	
		

	; SHOW_RGB_IMAGE 1, fg_w, fg_h, fg_image 
	SHOW_RGB_IMAGE 1, fg_w, fg_h, fg_mask    	
	; SHOW_RGB_IMAGE 3, bg_w, bg_h, bg_image 		
		
		

	; Priklad: 2
	; (odkomentujte nasledujicich 13 radku, prelozte a
	; spustte s parametrem -cl [./main -cl]
	;
	; movq mm0, [a]
	; movq mm1, [b]
	; call print_mm_regs_pb
	
	; paddb mm0, mm1
	 
	; call print_mm0_pb
	; call print_mm1_pb
	;
	; psubb mm1, mm0
	; 
	; call print_mm_regs_pb
	;

	; Priklad: 3
	; (odkomentujte nasledujicich 13 radku, prelozte a
	; spustte s parametrem -cl [./main -cl]
	; 
	; movups xmm0, [xa]
	; movups xmm1, [xb]
	;
	; call print_xmm_regs
	; addps xmm0, xmm1
	;
	; call print_xmm0
	; call print_xmm1
	;
	; subps xmm1, xmm0
	;
	; call print_xmm_regs
	
	; Epilog
	leave
        ret

;**************************************************************************
