        .MODEL small
        .STACK 100h

         ; ===============================
         ; Jednoduchy demonstracni program
	 ;     pro pripravek SEMAFOR
         ; ===============================

        .CODE

tabulka  dw     1000100000100010b       ; VZ=Cervena       SJ=Zelena
         dw     1100110001000100b       ; VZ=Cervena+zluta SJ=zluta
         dw     0010001010001000b       ; VZ=Zelena        SJ=Cernena
         dw     0100010011001100b       ; VZ=zluta         SJ=Cervena+zluta
         ;      CzZOCzZOCzZOCzZO          (O=Odboceni_doprava)
         ;      < Z>< V>< S>< J>


start:   mov  si,0                      ; Zacatek hlavniho programu
dalsi:   mov  ax,tabulka[si]            ; Nacteni slova z tabulky
         call vsend                     ; Odeslani na semafor pro vozidla
         mov  cx,4000h                  ; Pocet pruchodu cekaci smyckou
         call delay                     ; Cekani
         add  si,2                      ; Uprava indexregistru
         cmp  si,8                      ; Uz jsme odeslali vsechna 4 slova?
         jnz  dalsi                     ; ... ne, nacteme dalsi
         jmp  start                     ; ... ano, zpet na zacatek



delay:   push ax                        ; Aktivni cekani
vnejsi:  mov  ax,0ffffh
vnitrni: dec  ax
         jnz  vnitrni
         loop vnejsi
         pop  ax
         ret


vsend:                                  ; Vyslani 16-ti bitove hodnoty z AX
         mov  dx,378h                   ; Adresa vystupni brany LPT1:
         mov  cx,10h                    ; Citac pruchodu
         not  ax                        ; Negace AX (0=nesviti, 1=sviti)
vcykl:   ror  ax,1			; Vlastni cykl pro vyslani obsahu AX
         jc   vjedna			; Bit k odeslani = 1?
         call vsend0                    ; ... ne, vysli 0
         jmp  vskip                    
vjedna:  call vsend1                    ; ... ano, vysli 1
vskip:   loop vcykl                     ; a pokracuj s dalsi rotaci AX
         ret

vsend0:  push ax                        ; Zapis hodnoty 0 do pos. registru
         mov  al,0                      ; Data=0, hodiny=0
         out  dx,al
         mov  al,2                      ; Data=0, hodiny=1 (nabezna hrana)
         out  dx,al
         pop  ax
         ret

vsend1:  push ax                        ; Zapis hodnoty 1 do pos. registru
         mov  al,1                      ; Data=1, hodiny=0
         out  dx,al
         mov  al,3                      ; Data=1, hodiny=1 (nabezna hrana)
         out  dx,al
         pop  ax
         ret


         END start
