unit seznam;


interface

type
  spoj =^item;
  item = record
    k: string;
    h: word;
    d: spoj;
  end;

  head = record
    f,l: spoj;
  end;


  procedure init(var h: head);
  procedure VlozZa(var h: head; za, koho: spoj);
  procedure VlozPred(var h: head; pred, koho: spoj);
  procedure VlozNaZacatek(var h: head; koho: spoj);
  procedure VlozNaKonec(var h: head; koho: spoj);
  function najdi(var h: head; koho: string): Spoj;
  function vyjmi(var h: head; koho: spoj): spoj;


implementation

  procedure init(var h: head);
  begin
    h.f:= nil; h.l:= h.f;
  end;


  procedure VlozNaZacatek(var h: head; koho: spoj);
  begin
    koho^.d:=h.f;
    h.f:=koho;
    if h.l = nil then h.l:= koho;
  end;

  procedure VlozZa(var h: head; za, koho: spoj);
  begin
    if h.f = nil then {seznam je prazdny}
    begin
      h.f:= koho;
      h.l:= koho;
      koho^.d:= nil;
    end
    else
    begin
      koho^.D:= za^.d;
      za^.d:= koho;
      if h.l = za then h.l:= koho;
    end;
  end;

  procedure VlozPred(var h: head; pred, koho: spoj);
  var
    p: spoj;
  begin
    p^.d:= h.f;
    while (p^.d <> pred) and (p <> nil) do p:= p^.d;
    VlozZa(H,p,koho);
  end;

  procedure VlozNaKonec(var h: head; koho: spoj);
  begin
    VlozPred(h,nil,koho);
  end;

  function najdi(var h: head; koho: string): Spoj;
  var
    p: spoj;
  begin
   p:= h.f;
   while (p^.k <> koho) and (p <> nil) do p:= p^.d;
   najdi:= p;
  end;

  function vyjmi(var h: head; koho: spoj): spoj;
  var
    p: spoj;
  begin
    if h.f = koho then
    begin
      vyjmi:= koho;
      h.f:= h.f^.d;
      if h.l = koho then
      begin
        h.l:= nil; h.f:= nil;
      end;
    end
    else
    begin
      p^.d:= h.f;
      while (p^.d <> koho) and (p <> nil) do p:= p^.d;
      vyjmi:= koho;
      p^.d:= koho^.d;
      if h.l = koho then h.l:= p;
    end
  end;



end.