program txtgame;
uses dataStr, crt, parser, barvy, MeziTab, infofile;

const
  MAXMEET = 100;
  MAXR = 100;

var
   world: UkRoom;
   hero: tHero;
   f: text;
   run: boolean;
   AkceTyp,AkceHod: string;
   pVstup, pPar: pTab;




  Procedure rVypis(M: UkRoom);
    var
     visible: word; pomI: UkItem; pomC: UkCreature; i: byte;
   begin
     visible:= random(MAXMEET+1);
     hlaseni('Jsi v mistnosti '); hodnota(m^.name);
     hlaseni('Vidis '); vypis;write(m^.doors.pocet);
     hlaseni(' dvere vedouci do mistnosti '); vypis;
     for i:= 1 to m^.doors.pocet do
      write(m^.doors.dvere[i].jmeno,' ');writeln;
     if m^.desc <>'' then
      begin hlaseni('Popis mistnosti: '); hodnota(m^.desc); end;

     if M^.item <> nil then
      hlaseni('V mistnosti vidis tyto predmety: ');
     pomI:= M^.item;
     while pomI <> nil do
     begin
       if pomI^.meet > visible then hodnota(pomI^.name);
       pomI:= pomI^.next;
     end;

     if M^.creature <> nil then
      hlaseni('V mistnosti jsou tyto potvory: ');writeln;
     pomC:= M^.creature;
     while pomC <> nil do
     begin
       if pomC^.meet > visible then
       begin
        hlaseni('Jmeno: '); hodnota(pomC^.name);
        if pomC^.desc <> '' then hlaseni('Popis: '); hodnota(pomC^.desc);
       end;
       pomC:= pomC^.next;
     end;
   end; {rVypis}


  procedure iVypis (it: UkItem);
  begin
      writeln;
      hlaseni('jmeno predmetu: '); hodnota(it^.name);
      if (it^.desc <> '') and (not it^.endg) then
       begin; hlaseni('popis: '); hodnota(it^.desc); end;
      if it^.str <> 0 then
       begin hlaseni('sila: '); vypis; writeln(it^.str); end;
      if it^.con <> 0 then
       begin hlaseni('konstituce: '); vypis; writeln(it^.con); end;
      if it^.attack <> 0 then
       begin hlaseni('utok: '); vypis; writeln(it^.attack); end;
      if it^.def <> 0 then
       begin hlaseni('obrana: '); vypis; writeln(it^.def); end;
      if it^.live <> 0 then
       begin hlaseni('Zivoty k maximu: '); vypis; writeln(it^.live); end;
      if it^.curLive <> 0 then
       begin hlaseni('Leceni: '); vypis; writeln(it^.curLive); end;
      if it^.put = 0 then infoLn('neda se sebrat');
  end;


procedure cKill (potvora: UkCreature; var odkud: UkRoom);
  begin
    if potvora^.item <> nil then
     begin
       iAddToEnd(potvora^.item, odkud^.item);
       infoln('Z potvory vypadly predmety');
     end;
    cRemove(potvora,odkud^.creature);
    Dispose(potvora);
  end;


procedure InitHero(var hero:tHero; atrib: AttList; n:byte; svet:UkRoom; p:pTab);
   var
    pom,code,i:integer; j: hKoncetiny;
  begin
    for i:=1 to n do
     case preved(p,UpString(atrib[i].name)) of
      name:   hero.name:= atrib[i].value;
      str:    begin
               val(atrib[i].value,pom,code);
               hero.str:= pom
              end;
      con:    begin
               val(atrib[i].value,pom,code);
               hero.con:= pom
              end;
      live:   begin
               val(atrib[i].value,pom,code);
               hero.live:= pom
              end;
      curLive:begin
               val(atrib[i].value,pom,code);
               hero.curLive:= pom
              end;
      attack: begin
               val(atrib[i].value,pom,code);
               hero.attack:= pom
              end;
      def:    begin
               val(atrib[i].value,pom,code);
               hero.def:= pom
              end;
      exp:    begin
               val(atrib[i].value,pom,code);
               hero.exp:= pom
              end;
      start:  hero.pos:= rSearch(atrib[i].value,svet)
     end; {for}
    hero.inventar:= nil;
    for j:= prava to telo do hero.vystroj[j]:= nil;
  end; {InitHero}


procedure hVypisInv(h: tHero);
  var p: UkItem;
  begin
    hlaseni('  ******  Obsah inventare ****** ');
    if h.inventar <> nil then
    begin
      p:= h.inventar;
      while p <> nil do
      begin
        iVypis(p);
        p:= p^.next;
      end;
    end else begin writeln;chyba('invetar je prazdny'); end;
    hlaseni('  ****************************** ');writeln;
  end; {hVypisInv}


procedure hDejDoInv(var h: tHero; predmet:string);
  var
    p: UkItem;
  begin
    P:= iSearch(predmet,h.pos^.item);
    if p = nil then chyba('Neni to predmet, nebo zde neni')
    else
     if p^.put > 0 then
     begin
      iMove(p,h.pos^.item,h.inventar);
      infoln('Dal sis predmet do inventare');
      if p^.endg then
      begin
       run:= false;
       writeln; hodnota(p^.desc);
      end
     end
     else chyba('Tento predmet nemuzes sebrat')
  end; {hVypisInv}


procedure hVypisChar(h: tHero);
  begin
    hlaseni(' ****** Tvoje vlastnosti ******');writeln;
    hlaseni('Jmeno:      ');hodnota(h.name);
    hlaseni('zivoty:     ');vypis;writeln(h.curLive,' / ',h.Live);
    hlaseni('Zkusenost:  ');vypis;writeln(h.exp);
    writeln;
    hlaseni('sila:       ');vypis;writeln(h.str);
    hlaseni('odolnost:   ');vypis;writeln(h.con);
    hlaseni('utok:       ');vypis;writeln(h.attack);
    hlaseni('obrana:     ');vypis;writeln(h.def);
    writeln;
    hlaseni('prava ruka: ');vypis; if h.vystroj[prava] = nil then
     hodnota(' --- nic ---')
    else hodnota(h.vystroj[prava]^.name);
    hlaseni('leva ruka:  ');vypis; if h.vystroj[leva] = nil then
     hodnota(' --- nic ---')
    else hodnota(h.vystroj[leva]^.name);
    hlaseni('telo:       ');vypis; if h.vystroj[telo] = nil then
     hodnota(' --- nic ---')
    else hodnota(h.vystroj[telo]^.name);
    hlaseni(' ******************************');writeln;
  end;


  procedure hUseItem(var h: tHero; co: string; var odkud: UkItem);
  var
   p: UkItem;
  begin
   p:= iSearch(co,odkud);
   if p = nil then
    chyba('Tento predmet nemuzu najit')
   else
   begin
     if p^.put <> 4 then
      chyba('Tento predmet nemuzes pouzit')
     else
     begin
      h.str:= h.str + p^.str;
      h.con:= h.con + p^.con;
      h.def:= h.def + p^.def;
      h.live:= h.live + p^.live;
      h.curLive:= h.curLive + p^.curLive;
      if h.curLive > h.live then h.CurLive:= h.Live;
      h.attack:= h.attack + p^.attack;
      infoln('Vypil jsi lahvicku');
      Dispose(iRemove(p, odkud));
     end
   end
  end;

  procedure hOdeberVystroj( var h: tHero; k: hKoncetiny; var kam: UkItem);
  begin
    h.str:= h.str - h.vystroj[k]^.str;
    h.con:= h.con - h.vystroj[k]^.con;
    h.def:= h.def - h.vystroj[k]^.def;
    h.attack:= h.attack - h.vystroj[k]^.attack;
    h.live:= h.live - h.vystroj[k]^.live;
    if h.live < h.curLive then h.curLive:= h.live;
    iAdd(h.vystroj[k],kam);
    h.vystroj[k]:= nil;
  end;



  procedure hAddVystroj(var h: tHero; co: string; var odkud: UkItem; kam: hKoncetiny);
  var
   p: UkItem;
  begin
   p:= iSearch(co,odkud);
   if p = nil then chyba('Tento predmet nemuzu najit')
   else
   begin
     if (p^.put = 3) xor (kam = telo) 
      then chyba('Tento predmet sem nepatri')	
     else	
     if p^.put > 1 then
      begin
        if h.vystroj[kam] <> nil then hOdeberVystroj(h,kam,h.inventar);
        iMove(p,odkud,h.vystroj[kam]);
        h.str:= h.str + h.vystroj[kam]^.str;
        h.con:= h.con + h.vystroj[kam]^.con;
        h.def:= h.def + h.vystroj[kam]^.def;
        h.live:= h.live + h.vystroj[kam]^.live;
        h.curLive:= h.curLive + h.vystroj[kam]^.curLive;
        if h.curLive > h.live then h.CurLive:= h.Live;
        h.attack:= h.attack + h.vystroj[kam]^.attack;
        infoln('vzal si predmet');
      end
     else chyba('Tento predmet neumuzes dat do ruky nebo na sebe obleci');
   end;
  end;


  procedure hZahodItem(co: string; var h: tHero);
  var
   p: UkItem; i: hKoncetiny;
  begin
   p:= iSearch(co,h.inventar);
   if p <> nil then
   begin
    iMove(p,h.inventar,h.pos^.item);
    info; writeln('Zahodi jsi ',p^.name);
   end
   else
   begin
    for i:=prava to telo do
    begin
      p:= iSearch(co,h.vystroj[i]);
      if p <> nil then break;
    end; {for}
    if p <> nil then
    begin
     hOdeberVystroj(h,i,h.pos^.item);
     info; writeln('Zahodi jsi ',p^.name);
    end else chyba('Tuhle vec jsem u tebe nenasel a proto ji nemuzes zahodit');
   end;
  end; {hZahodItem}


  procedure Souboj(potvora: string; var h: tHero);
   var c: ukCreature; A, D, l : integer;
  begin
    c:= cSearch(potvora,h.pos^.creature);
    if c = nil then
     chyba('Potvora bohuzel v teto mistnosti neni, nemuzes ji zmlatit')
    else
    begin
      {souboj - utok hrdiny}
      repeat
        A:= random(h.attack);
        if A = 0 then
         hodnota('netrefil ses')
        else
        begin
          A:= A + h.str;
          D:= c^.con + random(c^.def);
          l:= D - A;
          if l < 0 then
          begin
            c^.live:= c^.live + l;
            info; writeln('potvora zranena (',l,')');
          end;
        end;
        {souboj - utok potvory pokud je nazivu}
        if c^.live > 0 then
        begin
          A:= random(c^.attack);
          if A = 0 then
           hodnota('potvora se netrefila')
          else
          begin
            A:= c^.str + A;
            D:= h.con + random(h.def);
            l:= D - A;
            if l < 0 then
            begin
              hero.curLive:= hero.CurLive + l;
              info; writeln(hero.name,' zranen (',l,')');
            end
          end
        end;
      until (hero.curLive < 0) or (c^.live < 0);
      if hero.CurLive <= 0 then  {vyhodnoceni souboje}
       begin
         hodnota('Jsi mrtvy, hra konci');
       end
      else
      begin
        hodnota('Potvora je mrtva');
        hero.exp:= hero. exp + c^.exp;
        if c^.endg then run:= false;
        cKill(c,h.pos);
      end;
    end {if}
  end; {hSouboj}


  procedure CheckAtckCr(var c: ukCreature; var h: tHero);
  var
    a: word;
  begin
    a:= random(MAXR);
    if c<> nil then 
     if c^.agr > a then
     begin
       writeln;
       hlaseni('Utoci na tebe '); Hodnota(c^.name); writeln;
       infoln('Pro pokracovani stiskni libovolnou klavesu...'); readkey;
       Souboj(c^.name,h);
     end;
  end; {CheckAtckCr}

  function LoadWorld (var f: text): UkRoom;
   var
    typ,count: string;
    fl,n: byte;
    atrib: AttList;
    zasobnik: UkPolozka;
    mistnost: UkRoom;
    potvora: UkCreature;
    predmet: UkItem;
    svet: UkRoom;
    {signalizace nacitani dat}
    pocR,pocC,pocI,pocD: word;
   begin
     mistnost:=nil; potvora:= nil; predmet:= nil; svet:= nil;
     pocR:=0;pocC:=0;pocI:=0;pocD:=0;
     Init(zasobnik); hlaseni('Nacitam data');
     while gettag(f,typ,fl,n,atrib,count) do
     begin
       typ:= UpString(typ);
       if (fl = STARTTAG) or (fl = SINGELTAG) then
        begin
          if typ = 'ROOM' then
          begin
            mistnost:= rNew(atrib, n, pPar);
            if fl = STARTTAG then Push(TypMist,mistnost,nil,nil,zasobnik);
            rAdd(mistnost,svet);
            inc(pocR); write('.');
          end
          else
          if typ = 'CREATURE' then
          begin
            potvora:= cNew(atrib,n,pPar);
            cAdd(potvora,zasobnik^.mistnost^.creature);
            if fl = STARTTAG then Push(TypPot,nil,potvora,nil,zasobnik);
            inc(pocC); write('.');
          end
          else
          if typ = 'ITEM' then
          begin
            predmet:= iNew(atrib,n,pPar);
            inc(pocI); write('.');
            Case zasobnik^.TypDat of
              TypMist: iAdd(predmet,zasobnik^.mistnost^.item);
              TypPot:  iAdd(predmet,zasobnik^.potvora^.item);
              TypHero: iAdd(predmet,Hero.inventar)
            end;
            if fl = STARTTAG then Push(TypPred,nil,nil,predmet,zasobnik);
          end
          else
          if typ = 'HERO' then
          begin
            initHero(Hero,atrib,n,svet,pPar);
            Push(TypHero,nil,nil,nil,zasobnik);
          end
          else
          if typ = 'DESC' then
          begin
            inc(pocD); write('.');
            case Zasobnik^.TypDat of
              TypMist: Zasobnik^.Mistnost^.desc:= Atrib[1].value;
              TypPot:  Zasobnik^.Potvora^.desc:= Atrib[1].value;
              TypPred: Zasobnik^.Predmet^.desc:= Atrib[1].value;
              TypHero: Hero.desc:= Atrib[1].value;
            end;
          end else if typ <> 'WORLD' then chyba('Chyba v XML souboru');
       end
       else
       if typ <> 'WORLD' then Pop(zasobnik);
     end; {while}
     rInitDoors(svet);
     LoadWorld:= svet;
     {informace o nacteni}
     writeln;writeln; textcolor(green);
     Writeln('Mistnosti: ',PocR);
     Writeln('Potvor:    ',PocC);
     Writeln('Predmetu:  ',PocI);
     Writeln('Popisu:    ',PocD);
     Delay(1500); clrscr;
   end; {LoadWorld}


   procedure FreeHero(h: tHero);
    var i: hKoncetiny;
        it,pom: ukItem;
   begin
    for i:= prava to telo do if h.vystroj[i] <> nil then dispose(h.vystroj[i]);
    it := h.inventar;
    while it <> nil do
    begin
     pom:= it;
     it:= it^.next;
     dispose(pom);
    end
   end;


   procedure CloseWorld(var svet: UkRoom; var h: tHero);
   var
     dr, pr: UkRoom; di, pi: UkItem; dc, pc: UkCreature;
   begin
     pr:= svet;
     writeln;hlaseni('Odstranuji herni data');
     while pr <> nil do
     begin
       pi:= pr^.item;
       pc:= pr^.creature;
       while pi <> nil do
       begin
         di:= pi;
         pi:= pi^.next;
         dispose(di);
       end;
       while pc <> nil do
       begin
         pi:= pc^.item;
         while pi <> nil do
         begin
           di:= pi;
           pi:= pi^.next;
           dispose(di);
         end;
         dc:= pc;
         pc:= pc^.next;
         dispose(dc);
       end;
       dr:= pr;
       pr:= pr^.next;
       dispose(dr);
       write('.');
     end; {while room}
     write('ok');
   end; {CloseWorld}

   procedure CtiVstup(var typ, hod: string);
    var s: string; i: integer;
   begin
     writeln;
     hlaseni('Co chces delat? '); vstup;
     readln(s);typ:='';hod:='';i:=1;writeln;
     while (s[i] = ' ') and (i <= length(s)) do inc(i); {preskoceni mezer}
     while (s[i] <> ' ') and (i <= length(s)) do {nacti typ}
     begin
       typ:= typ + s[i];
       inc(i);
     end;
     while (s[i] = ' ') and (i <= length(s)) do inc(i); {preskoceni mezer}
     while i <= length(s) do {nacti 1. hodnotu}
     begin
       hod:= hod + s[i];
       inc(i);
     end;
   end; {ctiVstup}


   procedure DoAction (t,hod: string);
   var
     typ,i: byte;
     r: UkRoom; it: UkItem;
   begin
     typ:= Preved(pVstup,UpString(t));
     case typ of
       jdi:     begin
                  r:= rSearchDoor(hod,hero.pos);
                  if r <> nil then
                   begin
                    hero.pos:= r;
                    rVypis(Hero.pos);
                    if Hero.pos^.endg then run:= false;
                   end else chyba('Dvere v teto mistnosti nejsou');
                end;
       zkoumat: begin
                  it:= iSearch(hod,Hero.pos^.item);
                  if it <> nil then iVypis(it)
                   else chyba('Tento predmet v mistnosti neni');
                end;
       seber:   hDejDoInv(hero,hod);
       utoc:    Souboj(hod,hero);
       char:    hVypisChar(hero);
       inv:     hVypisInv(hero);
       koukam:  rVypis(Hero.pos);
       p:   hAddVystroj(Hero,hod, hero.inventar,prava);
       l:   hAddVystroj(Hero,hod, hero.inventar,leva);
       te:  hAddVystroj(Hero,hod,hero.inventar,telo);
       use: hUseItem(Hero,hod, hero.inventar);
       zahodit: hZahodItem(hod,hero);
       konec: begin
                writeln; infoln('Dekuji za hrani hry');
                FreeHero(hero);
                CloseWorld(world,hero);
                delay(1000); halt
              end;
       neni: chyba ('Tento prikaz neznam, fakt nevim co mam delat!');
     end; {case}
   end;


   Procedure initGame;
   begin
     initTabVstup(pVstup);
     initTabPar(pPar);
     randomize;
     clrscr;gotoxy(1,5); textcolor(red);
     writeln('           TTTTTT xx   xx TTTTTT        gggg      a     m    m eeeee');
     writeln('             TT    xx xx    TT         g         a a    mm  mm e    ');
     writeln('             TT     xx      TT         g   gg   a   a   m mm m eee');
     writeln('             TT    xx xx    TT         g    g  aaaaaaa  m    m e    ');
     writeln('             TT   xx   xx   TT          gggg  aa     aa m    m eeeee');
     hlaseni('');
     writeln;writeln;
     writeln('Semestrln prce za 1. semest');
     writeln('Programoval: Michal Trs');
     writeln('Testoval: Soused Vlda');
     writeln;Writeln;
   end; {InitGame}

   Procedure Menu;
   var stav: 1..4;
       s: string;
   begin
    repeat
     hlaseni('');
     writeln; run:= false;
     Writeln('1. Nov hra');
     writeln('2. Nacst hru');
     writeln('3. Info');
     writeln('4. Konec hry');
     writeln;write('Tvoje volba: ');readln(stav);
     case stav of
       1:  if OpenFile(f,'data\data.xml') then
            begin
             World:= LoadWorld(f);
             hlaseni('Jmeno tveho hrdiny? '); vstup; readln(hero.name);
             Hero.curLive:= Hero.Live;
             run:= true;
            end
            else chyba('Chyba pri nactn dat!');
       2:  begin
             write('Jakou hru chces nacist? Zadej jmeno souboru: ');readln(s); s:='data\'+s+'.xml';
             if OpenFile(f,s) then
              begin
               World:= LoadWorld(f);
               run:= true;
              end
             else chyba('Chyba pri nactn dat')
           end;
       3:  getinfo;
       4: halt;

     end
    until run;
   end;


begin
  initGame;
  menu;
  if run then
  begin
    clrscr;
    rVypis(Hero.Pos);
    repeat
      CheckAtckCr(hero.pos^.creature,hero);
      CtiVstup(AkceTyp, AkceHod);
      DoAction(AkceTyp, AkceHod);
    until (hero.curLive <= 0) or not run;
  end;
  FreeHero(hero);
  CloseWorld(world,hero);
  readkey
end.