; Turbo Assembler    

ascii_bin PROC  NEAR                 ;prevede ascii v al na cislo
          cmp al,30h                 ;typ 1 dekad.cisla
          jl  chyba                  ;typ 0 hexadec.cislo
          cmp al,41h               
          jge pism                 ;v al je cislo 
          cmp al,39h               ;v ah je 0,pri prevodu
          jg  chyba                ;v ah je FF,pri chybe
          and al,0Fh
          mov ah,00h 
          jmp kon12
  pism:   mov ah,typ
          cmp ah,0
          jne chyba
          cmp al,47h
          jge chyba
          and al,0Fh
          add al,09
          mov ah,00h
          jmp kon12
  chyba:  mov ah,0FFh
  kon12:  ret
 ascii_bin  ENDP     

bin_ascii PROC  NEAR               ;prevede bin cislo v AL: 0Xh     
          mov ah,typ               ;na ascii hexa nebo dekad. 
          cmp ah,00h               ;typ=0 hexa
          jne dcislic              ;typ<=>0 dekad
          cmp al,0Ah
          jge pismo
 dekcis:  or  al,30h
          mov ah,00h
          jmp kon21
 pismo:   sub al,09h
          or  al,40h
          mov ah,00h
          jmp kon21 
 dcislic: cmp al,0Ah               ;v AL ascii
          jl  dekcis               ;v AH 00h-neni chyba
          mov ah,0FFh              ;    0FFh-cislo nebylo dekadicke 
 kon21:   ret
 bin_ascii   ENDP

oper_znak PROC  NEAR               ;hleda polohu operacniho znaku
          cld                      ;nastav smer-oper.znak v AL,pocet:CX,DX
    REPNE scasb                    ;hleda shodu-pocatek retezce v DI
                                   ;v CX pocet zbylych znaku retezce
          sub  dx,cx               ;v dx poloha znaku
          ret
oper_znak ENDP

bin_dec   PROC  NEAR               ;prevede bin.cislo v AX na dec.cislo
          mov  dx,0                ;take v AX ; cislo musi byt mensi 
          mov  cx,1000             ;nez 10 000
          div  cx                  ;tisicova cifra
          mov  cl,4
          shl  al,cl               ;posunuti cifry vlevo
          mov  bh,al
          xchg ax,dx               ;zbytek po deleni do AX
          mov  dx,0
          mov  cx,100
          div  cx                  ;stovkova cifra
          add  al,bh
          mov  bh,al               ;tisice a sta v BH
          xchg ax,dx               ;zbytek do AX
          mov  cl,10
          div  cl                  ;desitkova cifra
          mov  cl,4
          shl  al,cl
          add  al,ah               ;desitky a jednotky v al
          mov  ah,bh               ;vysledek v AX
          ret
bin_dec   ENDP

asc8dekb  PROC near                ;nacte a prevede 8 cifer na bin.tvar
          push di                  ;adresa prevedeneho cisla
          push si                  ;adresa buferu pro ascii znaky
          push bx                  ;adresa pomocneho slova
prednastaveni:                     ;zadani mozno ukoncit 'Enter'
          mov  bp,si
          mov  cx,8
   lad:   mov  BYTE PTR [si],30h
          inc  si
          loop lad
          mov  si,bp
          mov  cx,8                ;pocet znaku
sd1:      push cx                  ;ulozeni slov je podle konvence
   s1p:   cti_znak_ne              ;vyssi hodnota na vyssi adrese
          cmp al,13
          je  kon_zad
          cmp al,30h
          jb  s1p
          cmp al,39h
          ja  s1p
          mov [si],al
          pis_znak al
          inc si
          pop cx
          loop sd1                  ;znaky nacteny
          jmp prep_c 
kon_zad:  pop cx     ;pocet nenact.
          mov dx,8   
          sub dx,cx  ;pocet nactenych
          jz  prep_c
          xchg cx,dx
          mov si,bp
          add si,cx
          dec si
          mov di,bp
          add di,7
  a1:     mov al,[si]
          mov ah,[di]
          mov [di],al
          mov [si],ah 
          dec si
          dec di
          loop a1
prep_c:   mov cx,3
          pop di
          pop si
          pop bp
          push si
          push di
          call asc_dec_bin
          mov bx,10000  
          mul bx
          mov ds:[bp],ax
          mov ds:[bp+2],dx
          mov cx,3
          pop di
          pop si
          add si,4                  ;dalsi ctverice znaku
          call asc_dec_bin
          add ax,ds:[bp]
          mov ds:[bp],ax
          jnc ukonci
          inc WORD PTR ds:[bp+2]
 ukonci:  ret                        ;znaky prevedeny
asc8dekb  ENDP
asc_dec_bin PROC near                ;v CX pocet znaku-1,[si] adr.ascii
          mov WORD PTR [di],0        ;[di] adr.bin.cis
          mov bx,10
as1:      mov ah,0
          mov al,[si]
          and al,0Fh
          add ax,[di]
          mul bx
          mov [di],ax
          inc si
          loop as1
          mov al,[si]
          and al,0FH
          mov ah,0
          add ax,[di]
          mov [di],ax
          ret
asc_dec_bin ENDP
deleni   PROC near          ;deleni 32bit v AX:BX 16-ti bity na adr.[si]
         mov dx,0           ;vysledek ve dvojici BX:AX !!prehozeno!!
         div WORD PTR [si]
         xchg ax,bx
         div WORD PTR [si]
         ret
deleni   ENDP
bin_dec_ascii PROC near      ;v AX prevadene bin. cislo, [si] adr.ascii+3
         mov bx,10           ;retezce;CX pocet cifer-1
 bda1:   mov dx,0
         div bx
         xchg ax,dx
         add al,30h
         mov [si],al
         dec si
         xchg ax,dx
         loop bda1
         add al,30h
         mov [si],al
         ret
bin_dec_ascii ENDP
dekb8asc PROC near           ;prevod 32bit cisla <=99999999 na ascii
         mov dx,[di+2]       ;znaky adresovane [si] ,cislo ma adr.v [di] 
         mov ax,[di]
         mov bx,10000
         div bx
         mov bp,dx
         add si,3
         mov cx,3
         call bin_dec_ascii
         add si,7
         mov cx,3
         mov ax,bp
         call bin_dec_ascii
         ret                 ;znaky ulozeny v retezci
dekb8asc ENDP
vyprazdni PROC near
vypr0:
      stav_klav
      cmp al,0FFh          
      jne prazdno
      cti_znak_ne
      jmp vypr0
prazdno:
      ret
vyprazdni ENDP 